﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;


public abstract class NoteObject : MonoBehaviour
{
    public static Action<JudgeResult> OnNoteHit;
    protected float remainedTime;

    public Vector3 startPoint { get { return endPoint + new Vector3(0, 0, 50); } }
    public Vector3 endPoint;

	public float maxRemainedTime = 5;
	public float perfectZ = 10;

    protected virtual void OnDestroy()
    {
        
    }

    public void Awake()
    {
        remainedTime = maxRemainedTime;
    }

    public virtual void NoteHit(JudgeResult judge)
    {
        OnNoteHit?.Invoke(judge);
        Instantiate(PlayEngine.inst.hitEffectPrefabs[(int)(judge.type)], transform.position, Quaternion.identity);
        //Destroy(gameObject);
    }

    public virtual void SetPosition(float remainedTime)
    {
        float z = 250 * remainedTime;
        float t = Mathf.Pow(1 - z / 250, 3);
        transform.position = new Vector3(t * endPoint.x, t * endPoint.y, endPoint.z + z);
    }

    public abstract bool IsHit(Ray ray);
}
