﻿using System;
using System.Collections.Generic;
using UnityEngine;
class Level
{
    private Queue<Note> notes = new Queue<Note>();
    public double bpm;

    public void AddNote(Note note)
    {
        notes.Enqueue(note);
    }

    public void HandleInput(PlayerInput input)
    {
        foreach(var note in notes)
        {
            if (note.Active)
            {
                var judge = new JudgeResult();
                var hit = note.CheckHit(input.ray);

                Debug.Log(input.ray);

                judge.near = false;
                judge.type = JudgeType.Ignore;

                switch (hit)
                {
                    case HitType.Hit:
                        judge.type = note.JudgeTiming(input.time);
                        break;
                    case HitType.Near:
                        if (note.JudgeTiming(input.time) >= JudgeType.Hit)
                        {
                            judge.type = JudgeType.Miss;
                        }
                        judge.near = true;
                        break;
                    case HitType.Miss:
                        judge.near = false;
                        break;
                }

                note.HandleJudge(judge);
            }
        }
    }

    public void UpdateNotes(double time)
    {
        foreach (var note in notes)
        {
            float remainingTime = (float)(note.Time - time);
            note.Update(remainingTime);
        }
    }
}
