﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class EdgeNoteObject : NoteObject
{
    [SerializeField]
    private Vector3 direction;
    public void Init(HandType hand)
    {
        Material mat = GetComponent<Renderer>().material;
        switch(hand)
        {
            case HandType.Left:
                mat.color = Color.magenta;
                mat.SetColor("_EmissionColor", Color.magenta);
                break;
            case HandType.Right:
                mat.color = Color.cyan;
                mat.SetColor("_EmissionColor", Color.cyan);
                break;
        }
    }

    public override void NoteHit(NoteHitType type)
    {
    }

    public override void SetPosition(float remainedTime)
    {
        transform.position = Vector3.Lerp(endPoint, endPoint + new Vector3(0, 0, 200), remainedTime / maxRemainedTime);
    }

    public override bool IsHit(Ray ray)
    {
        return Mathf.Abs(Mathf.Acos(Vector3.Dot(direction.normalized, ray.direction))) < 30;
    }
}