﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Pillar : MonoBehaviour
{
    const float interval = 10.0f;
    private Vector3 origin;
    private float offsetTime;
    [SerializeField]
    private AnimationCurve curve;
    private void Start()
    {
        origin = transform.position;
        offsetTime = Random.Range(0, interval);
    }

    // Update is called once per frame
    private void Update()
    {
        transform.position = origin + new Vector3(0, 50 * curve.Evaluate(Mathf.PingPong(Time.time + offsetTime, interval) / interval));
    }
}
