﻿using UnityEngine;

public class MotionTracker
{
    private Vector3 lastPosition;
    private Vector3 currentPosition;

    private bool first;
    private bool active;
    public bool IsActive
    {
        get => active;
    }

    public Vector3 Velocity
    {
        get => currentPosition - lastPosition;
    }

    public MotionTracker()
    {
        lastPosition = Vector3.zero;
        currentPosition = Vector3.zero;
        first = true;
        active = true;
    }

    public void FeedPosition(Vector3 pos)
    {
        if (first)
        {
            lastPosition = currentPosition = pos;
            first = false;
        } else
        {
            lastPosition = currentPosition;
            currentPosition = pos;
        }
    }

    public void Deactivate()
    {
        first = true;
        active = false;
    }

    public void Activate()
    {
        active = true;
    }
}
