﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(Light),typeof(ParticleSystem))]
public class BlinkLight : MonoBehaviour
{
    public AnimationCurve curve;

    private float t = 0;
    private Light light;
    private ParticleSystem effect;

    public void Init(JudgeType type)
    {
        light = GetComponent<Light>();
        effect = GetComponent<ParticleSystem>();
        Color color = Color.white;
        switch (type)
        {
            case JudgeType.Perfect:
                color = Color.blue;
                break;
            case JudgeType.Hit:
                color = Color.green;
                break;
            case JudgeType.Miss:
                color = Color.red;
                break;
        }
        light.color = color;
        ParticleSystem.MainModule main = effect.main;
        main.startColor = color;
    }

    private void Update()
    {
        light.intensity = 20 * curve.Evaluate(Mathf.PingPong((t += 5 * Time.deltaTime), 1));
    }
}
