﻿Shader "Custom/Outline"
{
    Properties
    {
        _Color("Main Color", Color) = (1,1,1,1)
        _MainTex("Main Texture", 2D) = "white" {}
        _Outline("Outline", Range(0,2)) = 0.1
        _OutlineColor("Outline Color", Color) = (0,0,0,1)
    }

        SubShader
        {
            Tags { "Queue" = "Transparent" "IgnoreProjector" = "True" "RenderType" = "Transparent" }

            Pass
            {
                Blend SrcAlpha OneMinusSrcAlpha
                Cull Front
                ZWrite Off

                CGPROGRAM

                #pragma vertex vert
                #pragma fragment frag

                float _Outline;
                float4 _OutlineColor;

                struct appdata
                {
                    float4 vertex: POSITION;
                    float3 normal: NORMAL;
                };

                struct v2f
                {
                    float4 pos: SV_POSITION;
                };

                v2f vert(appdata v)
                {
                    v2f o;
                    v.vertex.xyz += normal * _Outline;
                    o.pos = UnityObjectToClipPos(v.vertex);
                    return o;
                }

                float4 frag(v2f i) : COLOR
                {
                    return _OutlineColor;
                }

                ENDCG
            }

            // 정상적으로 그리기
            Pass
            {
                Blend SrcAlpha OneMinusSrcAlpha

                CGPROGRAM

                #pragma vertex vert
                #pragma fragment frag

                half4 _Color;
                sampler2D _MainTex;
                float4 _MainTex_ST;

                struct appdata
                {
                    float4 vertex: POSITION;
                    float4 texcoord: TEXCOORD0;
                };

                struct v2f
                {
                    float4 pos: SV_POSITION;
                    float4 texcoord: TEXCOORD0;
                };

                v2f vert(appdata v)
                {
                    v2f o;
                    o.pos = UnityObjectToClipPos(v.vertex);
                    o.texcoord.xy = (v.texcoord.xy * _MainTex_ST.xy + _MainTex_ST.zw);
                    return o;
                }

                half4 frag(v2f i) : COLOR
                {
                    return tex2D(_MainTex, i.texcoord) * _Color;
                }

                ENDCG
            }
        }
}