﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ReloadNoteObject : NoteObject
{
    [SerializeField]
    private Transform[] cartridges = new Transform[2];
    private void Update()
    {
        cartridges[0].Rotate(new Vector3(0, 180 * Time.deltaTime, 0));
        cartridges[1].Rotate(new Vector3(0, -180 * Time.deltaTime, 0));
    }

    public override void NoteHit(JudgeResult judge)
    {
        
    }

    public override bool IsHit(Ray ray)
    {
        throw new System.NotImplementedException();
    }

    public override void SetPosition(float remainedTime)
    {
        transform.position = new Vector3(0f, -1.5f * Mathf.Pow(remainedTime, 2) + 1.5f, 0.4f);
        if (Mathf.Abs(remainedTime) < 0.5f)
        {
            foreach(var renderer in GetComponentsInChildren<MeshRenderer>())
            {
                renderer.material.color = Color.Lerp(Color.white, Color.red, 1 - 4 * Mathf.Pow(remainedTime, 2));
            }
        }
    }
}
