﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
public class ForwardNoteObject : NoteObject
{
    public RectTransform ring;
	public AnimationCurve curve;
	private Material mat;

    // 각 노트별 개별 함수이기 때문에 상속 관계 유지 불필요.
    public void Init(float x, float y, HandType handType)
    {
		//Vector3 point = Camera.main.ScreenToWorldPoint(new Vector3(Screen.width * x, Screen.height * y, Camera.main.nearClipPlane));
		//

		perfectZ = IngameUIManager.inst.transform.position.z;

		//Ray ray = Camera.main.ScreenPointToRay(new Vector3(Screen.width * x, Screen.height * y, 0));
		//endPoint = ray.GetPoint(perfectZ);

        endPoint = new Vector3(-100f + 200 * x, 100 * y, perfectZ);
		Ray ray = new Ray(Vector3.zero, endPoint.normalized);
		endPoint = ray.GetPoint(perfectZ);

		Debug.Log(endPoint);

        ring = IngameUIManager.inst.AddNoteRingUI();
        ring.position = endPoint;
		ring.LookAt(Vector3.zero);

        mat = GetComponent<Renderer>().material;

        switch (handType)
        {
            case HandType.Left:
                mat.SetColor("_EmissionColor", Color.magenta);
                mat.color = Color.magenta;
                GetComponentInChildren<Light>().color = Color.magenta;
                ring.GetComponent<Image>().color = Color.magenta;
                break;
            case HandType.Right:
                mat.SetColor("_EmissionColor", Color.cyan);
                mat.color = Color.cyan;
                GetComponentInChildren<Light>().color = Color.cyan;
                ring.GetComponent<Image>().color = Color.cyan;
                break;
        }
    }
    private void Start()
    {

    }

    private void OnDisable()
    {
        if (ring != null)
            ring.gameObject.SetActive(false);
    }

    private void OnEnable()
    {
        if (ring != null)
            ring.gameObject.SetActive(true);
    }

    protected override void OnDestroy()
    {
        base.OnDestroy();
        if(ring != null)
            Destroy(ring.gameObject);
    }

    public override void NoteHit(JudgeResult type)
    {
        base.NoteHit(type);
    }

    public override void SetPosition(float remainedTime)
    {
		//base.SetPosition(remainedTime);

		float z = 250 * remainedTime;
		//float t = Mathf.Pow(1 - z / 250, 3);
		float t = 1 - remainedTime;
		transform.position = new Vector3(curve.Evaluate(t) * endPoint.x, curve.Evaluate(t) * endPoint.y, endPoint.z + z);
		//transform.position = new Vector3(t * endPoint.x, t * endPoint.y, endPoint.z + z);

		var showRing = remainedTime < 0.3f;
        ring.localScale = Mathf.Max((1 + 20 * remainedTime), 0) * new Vector3(1, 1, 1);

        // change ring alpha
        var img = ring.gameObject.GetComponent<UnityEngine.UI.Image>();

        var color = img.color;
        color.a = showRing ? 1f - Mathf.Clamp(remainedTime / 0.3f, 0, 1f) : 0;
        img.color = color;
    }

    public override bool IsHit(Ray ray)
    {
        RaycastHit hit;
        return GetComponent<Collider>().Raycast(ray, out hit, 1000);
    }
}
