﻿#if (UNITY_EDITOR)
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor.Experimental.AssetImporters;
using System.IO;

[ScriptedImporter(1, "bms")]
public class BmsImporter : ScriptedImporter
{
    public override void OnImportAsset(AssetImportContext ctx)
    {
        var textAsset = new TextAsset(File.ReadAllText(ctx.assetPath));

        ctx.AddObjectToAsset(ctx.assetPath, textAsset);
        ctx.SetMainObject(textAsset);
    }
}
#endif