﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class IngameUIManager : SingletonBehaviour<IngameUIManager>
{
    public GameObject ringUIPrefab;

    public Text scoreText;
    public Text comboText;
    private Vector3 comboTextPosition;

    private void Start()
    {
        NoteObject.OnNoteHit += OnNoteHit;
    }
    public void OnNoteHit(JudgeResult type)
    {

    }
    
    public RectTransform AddNoteRingUI()
    {
        return Instantiate(ringUIPrefab, transform).GetComponent<RectTransform>();
    }

    public void UpdateScoreUI(int score)
    {
        scoreText.text = score.ToString();
    }
    public void UpdateComboUI(int combo)
    {
        if (combo < 1)
            comboText.text = "";
        else
        {
            comboText.text = combo.ToString() + " Combo!";
            StartCoroutine(ComboRoutine());
        }
    }
    private IEnumerator ComboRoutine()
    {
        for (float t = 0; t < 0.2f; t += Time.deltaTime) {
            comboText.transform.localPosition = Vector3.Lerp(new Vector3(0, 10), Vector3.zero, t * 5);
            yield return new WaitForEndOfFrame();
        }
        comboText.transform.localPosition = Vector3.zero;
    }
}
