﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public enum UISetType
{
    INGAME,
    SELECTION,
    RESULT
}

public class IngameUIManager : SingletonBehaviour<IngameUIManager>
{
    public GameObject ringUIPrefab;

    public Text scoreText;
    public Text comboText;
    private Vector3 comboTextPosition;

    private int musicIdx = 0;
    public Image prevMusicImage, nextMusicImage, curMusicImage;
    public Text musicNameText;

    public List<GameObject> UISetList = new List<GameObject>();

    public Text perfectCountText, hitCountText, missCountText, scoreResultText, maxComboText;

    public AudioSource changeMusicSfx;
    public AudioSource buttonSfx;
    private void Start()
    {
        NoteObject.OnNoteHit += OnNoteHit;
        ChangeUISet(UISetType.SELECTION);
        OnChangeMusicButtonClicked(0);
    }
    public void OnNoteHit(JudgeResult type)
    {

    }
    
    public RectTransform AddNoteRingUI()
    {
        return Instantiate(ringUIPrefab, transform).GetComponent<RectTransform>();
    }

    public void UpdateScoreUI(int score)
    {
        scoreText.text = score.ToString();
    }
    public void UpdateComboUI(int combo)
    {
        if (combo < 1)
            comboText.text = "";
        else
        {
            comboText.text = combo.ToString() + " Combo!";
            StartCoroutine(ComboRoutine());
        }
    }
    private IEnumerator ComboRoutine()
    {
        for (float t = 0; t < 0.2f; t += Time.deltaTime) {
            comboText.transform.localPosition = Vector3.Lerp(new Vector3(0, 10), Vector3.zero, t * 5);
            yield return new WaitForEndOfFrame();
        }
        comboText.transform.localPosition = Vector3.zero;
    }

    public void OnChangeMusicButtonClicked(int delta)
    {
        changeMusicSfx.Play();
        int musicCount = PlayEngine.inst.levelList.Length;
        musicIdx += delta;
        if (musicIdx < 0)
        {
            musicIdx = musicCount - 1;
        }
        else if (musicIdx > musicCount - 1)
        {
            musicIdx = 0;
        }
        LevelScriptableObject cur = PlayEngine.inst.levelList[musicIdx];
        LevelScriptableObject prev = PlayEngine.inst.levelList[musicIdx - 1 >= 0 ? musicIdx - 1 : musicCount - 1];
        LevelScriptableObject next = PlayEngine.inst.levelList[musicIdx + 1 < musicCount ? musicIdx + 1 : 0];

        prevMusicImage.sprite = prev.image;
        curMusicImage.sprite = cur.image;
        nextMusicImage.sprite = next.image;

        musicNameText.text ="♪ " + cur.title;
    }
    public void OnStartButtonClicked()
    {
        PlayEngine.inst.LoadAndPlay(musicIdx);
        ChangeUISet(UISetType.INGAME);
        buttonSfx.Play();
    }

    public void BackToSelection()
    {
        ChangeUISet(1);
        buttonSfx.Play();
    }
    public void ChangeUISet(UISetType type)
    {
        ChangeUISet((int)type);
    }
    public void ChangeUISet(int idx)
    {
        foreach(var set in UISetList)
        {
            set.SetActive(false);
        }
        UISetList[idx].SetActive(true);
    }

    public void UpdateResultUIs(int perfect, int hit, int miss, int score, int combo)
    {
        perfectCountText.text = perfect.ToString();
        hitCountText.text = hit.ToString();
        missCountText.text = miss.ToString();
        scoreResultText.text = score.ToString();
        maxComboText.text = "x " + combo.ToString();
    }
}
