﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class EdgeNoteObject : NoteObject
{
    [SerializeField]
    private Vector3 direction;
    private const float radius = 10f;

    public void Init(HandType hand)
    {
        Material mat = GetComponent<Renderer>().material;
        switch(hand)
        {
            case HandType.Left:
                mat.color = Color.magenta;
                mat.SetColor("_EmissionColor", Color.magenta);
                break;
            case HandType.Right:
                mat.color = Color.cyan;
                mat.SetColor("_EmissionColor", Color.cyan);
                break;
        }
    }

    public override void NoteHit(JudgeResult type)
    {
        PlayJudgeSfx(type);

        PlayEngine.inst.HandleNoteJudge(type);
        BlinkLight light = Instantiate(PlayEngine.inst.edgeHitEffectPrefab, -5 * direction, Quaternion.identity);
        light.transform.LookAt(Vector3.zero);
        light.Init(type.type);
        Destroy(light.gameObject, 0.4f);
    }

    public override void SetPosition(float remainedTime)
    {

        //if (remainedTime > 0.5f)
        //{
        //    transform.position = new Vector3(0, 0, Mathf.Lerp(radius, 500, (remainedTime - 0.5f) * 2));
        //}
        //else
        //{
        //    float angle = Mathf.Lerp(0, 90, Mathf.Pow(remainedTime * 2 - 1, 2));
        //    transform.position = Quaternion.Euler(direction.x * angle, direction.y * angle, 0) * new Vector3(0, 0, radius);
        //    transform.LookAt(Vector3.zero);
        //}
        transform.position = endPoint + new Vector3(0, 0, 300) * remainedTime;
    } 

    public override bool IsHit(PlayerInput input)
    {
        return Mathf.Abs(Mathf.Acos(Vector3.Dot(direction.normalized, input.ray.direction))) < 30;
    }
}