﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ForwardNoteObject : NoteObject
{
    public RectTransform ring;

    // 각 노트별 개별 함수이기 때문에 상속 관계 유지 불필요.
    public void Init(float x, float y, HandType handType)
    {
        //Vector3 point = Camera.main.ScreenToWorldPoint(new Vector3(Screen.width * x, Screen.height * y, Camera.main.nearClipPlane));
        //

        perfectZ = IngameUIManager.inst.transform.position.z;
        Ray ray = Camera.main.ScreenPointToRay(new Vector3(Screen.width * x, Screen.height * y, Camera.main.nearClipPlane));
        endPoint = ray.GetPoint(perfectZ);
       
        Debug.Log(endPoint);

        transform.position = endPoint + new Vector3(0, 0, 50);
        ring = IngameUIManager.inst.AddNoteRingUI();
        ring.position = endPoint;

        Material mat = GetComponent<Renderer>().material;

        switch (handType)
        {
            case HandType.Left:
                mat.color = Color.red;
                break;
            case HandType.Right:
                mat.color = Color.blue;
                break;


        }
    }
    private void Start()
    {
    }

    private void OnDisable()
    {
        if (ring != null)
            ring.gameObject.SetActive(false);
    }

    private void OnEnable()
    {
        if (ring != null)
            ring.gameObject.SetActive(true);
    }

    protected override void OnDestroy()
    {
        base.OnDestroy();
        if(ring != null)
            Destroy(ring.gameObject);
    }

    public override void NoteHit(NoteHitType type)
    {
        //OnNoteHit(NoteHitType.PERFECT, 300);
    }

    public override void SetPosition(float remainedTime)
    {
        base.SetPosition(remainedTime);
        ring.localScale = (1 + 4 * remainedTime / maxRemainedTime) * new Vector3(1, 1, 1);
        
        // change ring alpha
        var img = ring.gameObject.GetComponent<UnityEngine.UI.Image>();

        var color = img.color;
        color.a = 1f-Mathf.Clamp(remainedTime / maxRemainedTime, 0, 1);
        img.color = color;
    }
}
