// Shader created with Shader Forge v1.40 
// Shader Forge (c) Freya Holmer - http://www.acegikmo.com/shaderforge/
// Note: Manually altering this data may prevent you from opening it in Shader Forge
/*SF_DATA;ver:1.40;sub:START;pass:START;ps:flbk:,iptp:0,cusa:False,bamd:0,cgin:,cpap:True,lico:1,lgpr:1,limd:0,spmd:1,trmd:0,grmd:0,uamb:True,mssp:True,bkdf:False,hqlp:False,rprd:False,enco:False,rmgx:True,imps:True,rpth:0,vtps:0,hqsc:True,nrmq:1,nrsp:0,vomd:0,spxs:False,tesm:0,olmd:1,culm:0,bsrc:3,bdst:7,dpts:2,wrdp:False,dith:0,atcv:False,rfrpo:True,rfrpn:Refraction,coma:15,ufog:True,aust:True,igpj:True,qofs:0,qpre:3,rntp:2,fgom:False,fgoc:False,fgod:False,fgor:False,fgmd:0,fgcr:0.5,fgcg:0.5,fgcb:0.5,fgca:1,fgde:0.01,fgrn:0,fgrf:300,stcl:False,atwp:False,stva:128,stmr:255,stmw:255,stcp:6,stps:0,stfa:0,stfz:0,ofsf:0,ofsu:0,f2p0:False,fnsp:False,fnfb:False,fsmp:False;n:type:ShaderForge.SFN_Final,id:9361,x:34597,y:32650,varname:node_9361,prsc:2|diff-2401-OUT,emission-5096-RGB,alpha-1670-OUT;n:type:ShaderForge.SFN_Color,id:3941,x:32896,y:32711,ptovrint:False,ptlb:Color,ptin:_Color,varname:node_3941,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,c1:0,c2:1,c3:1,c4:1;n:type:ShaderForge.SFN_Multiply,id:9604,x:33065,y:32759,varname:node_9604,prsc:2|A-3941-RGB,B-734-OUT;n:type:ShaderForge.SFN_Slider,id:734,x:32817,y:32976,ptovrint:False,ptlb:Intensity,ptin:_Intensity,varname:node_734,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:1,max:1;n:type:ShaderForge.SFN_DepthBlend,id:9154,x:33302,y:33227,varname:node_9154,prsc:2;n:type:ShaderForge.SFN_Color,id:7224,x:32947,y:33152,ptovrint:False,ptlb:Intersection Color,ptin:_IntersectionColor,varname:_Color_copy,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,c1:0,c2:1,c3:1,c4:1;n:type:ShaderForge.SFN_Multiply,id:7599,x:33116,y:33200,varname:node_7599,prsc:2|A-7224-RGB,B-8345-OUT;n:type:ShaderForge.SFN_Slider,id:8345,x:32868,y:33417,ptovrint:False,ptlb:Intersection Intensity,ptin:_IntersectionIntensity,varname:_Intensity_copy,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:1,max:1;n:type:ShaderForge.SFN_Lerp,id:3078,x:33207,y:32952,varname:node_3078,prsc:2|A-9604-OUT,B-7599-OUT,T-9154-OUT;n:type:ShaderForge.SFN_Tex2d,id:5816,x:34143,y:33269,ptovrint:False,ptlb:Shield Txture,ptin:_ShieldTxture,varname:node_5816,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,tex:a0f6e9a63c73f9c45aa0faf8e7cb2a07,ntxv:0,isnm:False|UVIN-5641-OUT;n:type:ShaderForge.SFN_ComponentMask,id:8988,x:34316,y:33224,varname:node_8988,prsc:2,cc1:0,cc2:-1,cc3:-1,cc4:-1|IN-5816-RGB;n:type:ShaderForge.SFN_Fresnel,id:2647,x:33466,y:32717,varname:node_2647,prsc:2|NRM-3709-OUT,EXP-6263-OUT;n:type:ShaderForge.SFN_NormalVector,id:3709,x:33276,y:32609,prsc:2,pt:False;n:type:ShaderForge.SFN_Multiply,id:2871,x:33480,y:32879,varname:node_2871,prsc:2|A-3078-OUT,B-2647-OUT;n:type:ShaderForge.SFN_Time,id:6109,x:33310,y:33503,varname:node_6109,prsc:2;n:type:ShaderForge.SFN_Multiply,id:762,x:33844,y:32874,varname:node_762,prsc:2|A-2871-OUT,B-5287-OUT;n:type:ShaderForge.SFN_TexCoord,id:6734,x:33512,y:33158,varname:node_6734,prsc:2,uv:0,uaff:False;n:type:ShaderForge.SFN_Vector1,id:8799,x:33674,y:33521,varname:node_8799,prsc:2,v1:10;n:type:ShaderForge.SFN_Vector1,id:6263,x:33280,y:32764,varname:node_6263,prsc:2,v1:1;n:type:ShaderForge.SFN_Time,id:7398,x:33429,y:33351,varname:node_7398,prsc:2;n:type:ShaderForge.SFN_Frac,id:8375,x:33638,y:33369,varname:node_8375,prsc:2|IN-7398-TSL;n:type:ShaderForge.SFN_Add,id:8758,x:33798,y:33325,varname:node_8758,prsc:2|A-6734-V,B-8375-OUT;n:type:ShaderForge.SFN_Append,id:5641,x:33904,y:33204,varname:node_5641,prsc:2|A-8758-OUT,B-6734-U;n:type:ShaderForge.SFN_Multiply,id:5287,x:34533,y:33303,varname:node_5287,prsc:2|A-8988-OUT,B-9292-OUT;n:type:ShaderForge.SFN_Multiply,id:5730,x:33926,y:33501,varname:node_5730,prsc:2|A-8799-OUT,B-3181-OUT;n:type:ShaderForge.SFN_Sin,id:2051,x:34069,y:33474,varname:node_2051,prsc:2|IN-5730-OUT;n:type:ShaderForge.SFN_Noise,id:3181,x:33904,y:33089,varname:node_3181,prsc:2|XY-9082-OUT;n:type:ShaderForge.SFN_RemapRange,id:9292,x:34239,y:33456,varname:node_9292,prsc:2,frmn:-1,frmx:1,tomn:0.2,tomx:1|IN-2051-OUT;n:type:ShaderForge.SFN_Multiply,id:9082,x:33747,y:33073,varname:node_9082,prsc:2|A-6734-UVOUT,B-7398-TTR;n:type:ShaderForge.SFN_Vector1,id:2213,x:33613,y:33278,varname:node_2213,prsc:2,v1:10;n:type:ShaderForge.SFN_Add,id:6120,x:34052,y:32717,varname:node_6120,prsc:2;n:type:ShaderForge.SFN_Blend,id:2401,x:34018,y:32549,varname:node_2401,prsc:2,blmd:0,clmp:True|SRC-2871-OUT,DST-762-OUT;n:type:ShaderForge.SFN_Slider,id:8126,x:33418,y:33038,ptovrint:False,ptlb:opacity,ptin:_opacity,varname:node_8126,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:1,max:1;n:type:ShaderForge.SFN_ComponentMask,id:9367,x:34223,y:32637,varname:node_9367,prsc:2,cc1:1,cc2:-1,cc3:-1,cc4:-1|IN-2401-OUT;n:type:ShaderForge.SFN_Multiply,id:1670,x:34185,y:33054,varname:node_1670,prsc:2|A-8126-OUT,B-9367-OUT;n:type:ShaderForge.SFN_Color,id:5096,x:34185,y:32890,ptovrint:False,ptlb:emision,ptin:_emision,varname:node_5096,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,c1:0.5,c2:0.5,c3:0.5,c4:1;proporder:3941-734-7224-8345-5816-8126-5096;pass:END;sub:END;*/

Shader "Shader Forge/Laser" {
    Properties {
        _Color ("Color", Color) = (0,1,1,1)
        _Intensity ("Intensity", Range(0, 1)) = 1
        _IntersectionColor ("Intersection Color", Color) = (0,1,1,1)
        _IntersectionIntensity ("Intersection Intensity", Range(0, 1)) = 1
        _ShieldTxture ("Shield Txture", 2D) = "white" {}
        _opacity ("opacity", Range(0, 1)) = 1
        _emision ("emision", Color) = (0.5,0.5,0.5,1)
        [HideInInspector]_Cutoff ("Alpha cutoff", Range(0,1)) = 0.5
    }
    SubShader {
        Tags {
            "IgnoreProjector"="True"
            "Queue"="Transparent"
            "RenderType"="Transparent"
        }
        Pass {
            Name "FORWARD"
            Tags {
                "LightMode"="ForwardBase"
            }
            Blend SrcAlpha OneMinusSrcAlpha
            ZWrite Off
            
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            #pragma multi_compile_instancing
            #include "UnityCG.cginc"
            #pragma multi_compile_fwdbase
            #pragma multi_compile_fog
            #pragma target 3.0
            uniform sampler2D _CameraDepthTexture;
            uniform sampler2D _ShieldTxture; uniform float4 _ShieldTxture_ST;
            UNITY_INSTANCING_BUFFER_START( Props )
                UNITY_DEFINE_INSTANCED_PROP( float4, _Color)
                UNITY_DEFINE_INSTANCED_PROP( float, _Intensity)
                UNITY_DEFINE_INSTANCED_PROP( float4, _IntersectionColor)
                UNITY_DEFINE_INSTANCED_PROP( float, _IntersectionIntensity)
                UNITY_DEFINE_INSTANCED_PROP( float, _opacity)
                UNITY_DEFINE_INSTANCED_PROP( float4, _emision)
            UNITY_INSTANCING_BUFFER_END( Props )
            struct VertexInput {
                float4 vertex : POSITION;
                float3 normal : NORMAL;
                float2 texcoord0 : TEXCOORD0;
            };
            struct VertexOutput {
                float4 pos : SV_POSITION;
                UNITY_VERTEX_INPUT_INSTANCE_ID
                float2 uv0 : TEXCOORD0;
                float4 posWorld : TEXCOORD1;
                float3 normalDir : TEXCOORD2;
                float4 projPos : TEXCOORD3;
                UNITY_FOG_COORDS(4)
            };
            VertexOutput vert (VertexInput v) {
                VertexOutput o = (VertexOutput)0;
                UNITY_SETUP_INSTANCE_ID( v );
                UNITY_TRANSFER_INSTANCE_ID( v, o );
                o.uv0 = v.texcoord0;
                o.normalDir = UnityObjectToWorldNormal(v.normal);
                o.posWorld = mul(unity_ObjectToWorld, v.vertex);
                o.pos = UnityObjectToClipPos( v.vertex );
                UNITY_TRANSFER_FOG(o,o.pos);
                o.projPos = ComputeScreenPos (o.pos);
                COMPUTE_EYEDEPTH(o.projPos.z);
                return o;
            }
            float4 frag(VertexOutput i) : COLOR {
                UNITY_SETUP_INSTANCE_ID( i );
                i.normalDir = normalize(i.normalDir);
                float3 viewDirection = normalize(_WorldSpaceCameraPos.xyz - i.posWorld.xyz);
                float3 normalDirection = i.normalDir;
                float sceneZ = max(0,LinearEyeDepth (UNITY_SAMPLE_DEPTH(tex2Dproj(_CameraDepthTexture, UNITY_PROJ_COORD(i.projPos)))) - _ProjectionParams.g);
                float partZ = max(0,i.projPos.z - _ProjectionParams.g);
////// Lighting:
////// Emissive:
                float4 _emision_var = UNITY_ACCESS_INSTANCED_PROP( Props, _emision );
                float3 emissive = _emision_var.rgb;
                float3 finalColor = emissive;
                float _opacity_var = UNITY_ACCESS_INSTANCED_PROP( Props, _opacity );
                float4 _Color_var = UNITY_ACCESS_INSTANCED_PROP( Props, _Color );
                float _Intensity_var = UNITY_ACCESS_INSTANCED_PROP( Props, _Intensity );
                float4 _IntersectionColor_var = UNITY_ACCESS_INSTANCED_PROP( Props, _IntersectionColor );
                float _IntersectionIntensity_var = UNITY_ACCESS_INSTANCED_PROP( Props, _IntersectionIntensity );
                float3 node_2871 = (lerp((_Color_var.rgb*_Intensity_var),(_IntersectionColor_var.rgb*_IntersectionIntensity_var),saturate((sceneZ-partZ)))*pow(1.0-max(0,dot(i.normalDir, viewDirection)),1.0));
                float4 node_7398 = _Time;
                float2 node_5641 = float2((i.uv0.g+frac(node_7398.r)),i.uv0.r);
                float4 _ShieldTxture_var = tex2D(_ShieldTxture,TRANSFORM_TEX(node_5641, _ShieldTxture));
                float2 node_9082 = (i.uv0*node_7398.a);
                float2 node_3181_skew = node_9082 + 0.2127+node_9082.x*0.3713*node_9082.y;
                float2 node_3181_rnd = 4.789*sin(489.123*(node_3181_skew));
                float node_3181 = frac(node_3181_rnd.x*node_3181_rnd.y*(1+node_3181_skew.x));
                float3 node_2401 = saturate(min(node_2871,(node_2871*(_ShieldTxture_var.rgb.r*(sin((10.0*node_3181))*0.4+0.6)))));
                fixed4 finalRGBA = fixed4(finalColor,(_opacity_var*node_2401.g));
                UNITY_APPLY_FOG(i.fogCoord, finalRGBA);
                return finalRGBA;
            }
            ENDCG
        }
    }
    FallBack "Diffuse"
    CustomEditor "ShaderForgeMaterialInspector"
}
