﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public enum NoteHitType
{
    PERFECT,
    GOOD,
    BAD,
    MISS
}

public abstract class NoteObject : MonoBehaviour
{
    public static Action<NoteHitType, int> OnNoteHit;
    protected float remainedTime;

    public Vector3 startPoint { get { return endPoint + new Vector3(0, 0, 50); } }
    public Vector3 endPoint;

	public float maxRemainedTime = 1;
	public float perfectZ = 10;


    protected virtual void OnDestroy()
    {
        
    }

    public virtual void Init(float x, float y)
    {
        remainedTime = maxRemainedTime;
    }


    public abstract void NoteHit(NoteHitType type);

    public virtual void SetPosition(float remainedTime)
    {
        transform.position = endPoint + new Vector3(0, 0, 50) * remainedTime / maxRemainedTime;
    }
}
