﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ForwardNoteObject : NoteObject
{
    public RectTransform ring;

    public override void Init(float x, float y)
    {
        base.Init(x, y);
        //Vector3 point = Camera.main.ScreenToWorldPoint(new Vector3(Screen.width * x, Screen.height * y, Camera.main.nearClipPlane));
        //

        perfectZ = IngameUIManager.inst.transform.position.z;
        Ray ray = Camera.main.ScreenPointToRay(new Vector3(Screen.width * x, Screen.height * y, Camera.main.nearClipPlane));
        endPoint = ray.GetPoint(perfectZ);
       
        Debug.Log(endPoint);

        transform.position = endPoint + new Vector3(0, 0, 50);
        ring = IngameUIManager.inst.AddNoteRingUI();
        ring.position = endPoint;
    }
    private void Start()
    {
    }

    private void OnDisable()
    {
        ring.gameObject.SetActive(false);
    }

    private void OnEnable()
    {
        ring.gameObject.SetActive(true);
    }

    protected override void OnDestroy()
    {
        base.OnDestroy();
        Destroy(ring.gameObject);
    }

    public override void NoteHit(NoteHitType type)
    {
        //OnNoteHit(NoteHitType.PERFECT, 300);
    }

    public override void SetPosition(float remainedTime)
    {
        base.SetPosition(remainedTime);
        ring.localScale = (1 + 4 * remainedTime / maxRemainedTime) * new Vector3(1, 1, 1);
    }
}
