﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class IngameUIManager : SingletonBehaviour<IngameUIManager>
{
    public GameObject ringUIPrefab;

    public Text scoreText;
    public Text comboText;

    private void Start()
    {
        NoteObject.OnNoteHit += OnNoteHit;
    }
    public void OnNoteHit(NoteHitType type)
    {

    }
    
    public RectTransform AddNoteRingUI()
    {
        return Instantiate(ringUIPrefab, transform).GetComponent<RectTransform>();
    }

    public void UpdateScoreUI(int score)
    {
        scoreText.text = score.ToString();
    }
    public void UpdateComboUI(int combo)
    {
        if (combo < 1)
            comboText.text = "";
        else
            comboText.text = combo.ToString() + " Combo!";
    }
}
