﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ReloadNoteObject : NoteObject
{
    [SerializeField]
    private Transform[] cartridges = new Transform[2];
    [SerializeField]
    private Transform text;
    private void Update()
    {
        cartridges[0].Rotate(new Vector3(540 * Time.deltaTime, 0, 0));
        cartridges[1].Rotate(new Vector3(-540 * Time.deltaTime, 0, 0));
    }

    public override void NoteHit(JudgeResult judge)
    {
        PlayJudgeSfx(judge);

        GameObject hitEffect = null;
        // hit effect

        if (judge.type == JudgeType.Perfect)
            hitEffect = PlayEngine.inst.hitEffectPrefabs[0];
        if (judge.type == JudgeType.Hit)
            hitEffect = PlayEngine.inst.hitEffectPrefabs[1];
        if (judge.type == JudgeType.Miss)
            hitEffect = PlayEngine.inst.hitEffectPrefabs[2];
        OnNoteHit?.Invoke(judge);

        if (hitEffect && judge.type != JudgeType.Ignore)
        {
            Instantiate(hitEffect, transform.position, Quaternion.identity);
            StartCoroutine(DissolveRoutine());

            PlayEngine.inst.HandleNoteJudge(judge.type);
        }
    }

    private IEnumerator DissolveRoutine()
    {
        Material mat = new Material(Shader.Find("Unlit/Dissolve"));
        MeshRenderer[] mrs = GetComponentsInChildren<MeshRenderer>();

        foreach (var mr in mrs) {
            mat.SetColor("_Color", mr.material.color);
            mat.SetColor("_Glow", (Color.white + mr.material.color) / 2);
            mr.material = mat;

            Texture2D noise = new Texture2D(100, 100);

            float scale = UnityEngine.Random.Range(20, 50);
            for (int i = 0; i < noise.width; ++i)
            {
                for (int j = 0; j < noise.height; ++j)
                {
                    float noiseVal = Mathf.PerlinNoise(scale * i / noise.width, scale * j / noise.height);
                    noise.SetPixel(i, j, new Color(noiseVal, noiseVal, noiseVal, 1));
                }
            }
            noise.Apply();
            mat.SetTexture("_NoiseTex", noise);

            const float time = 0.5f;

            for (float t = 0; t < time; t += Time.deltaTime)
            {
                mat.SetFloat("_Threshold", t / time);
                mat.SetColor("_Color", mat.color - new Color(0, 0, 0, 2) * Time.deltaTime);
                yield return null;
            }
            mat.SetFloat("_Threshold", 1);
        }
    }

    public void Init()
    {

    }

    public override bool IsHit(PlayerInput input)
    {
        return false;
    }

    public override void SetPosition(float remainedTime)
    {
        foreach (var cat in cartridges) {
            var pos = cat.localPosition;
            cat.localPosition = new Vector3(pos.x, -0.25f * Mathf.Pow((remainedTime-0.01f) * 3, 4) + 1f, 1f);
        }
        if (Mathf.Abs(remainedTime) < 0.1f)
        {
            foreach(var cat in cartridges)
            {

                var renderer = cat.gameObject.GetComponentInChildren<MeshRenderer>();
                renderer.material.color = Color.Lerp(Color.white, Color.red, 1 - 4 * Mathf.Pow(remainedTime, 3));
            }
        }

        text.position = endPoint + new Vector3(0, 0, 300) * remainedTime;

    }
}
