﻿using System;
using System.Collections.Generic;
using UnityEngine;
class Level
{
    private Queue<Note> notes = new Queue<Note>();
    public double bpm;

    public void AddNote(Note note)
    {
        notes.Enqueue(note);
    }

    public void HandleInput(PlayerInput input)
    {
        foreach(var note in notes)
        {
            if (note.IsActive)
            {
                JudgeResult judge = Judge(input, note);

                if (judge.type != JudgeType.Ignore)
                {
                    note.HandleJudge(judge);
                    note.Deactivate();
                    break;
                }

            }
        }
    }

    public void HandleMotion(PlayerMotion motion)
    {
        foreach(var n in notes)
        {
            ActionNote note = n as ActionNote;
            if (note != null && note.IsActive)
            {
                if (Math.Abs(note.Time - motion.time) < 0.05f)
                {
                    if (note.CheckMotion(motion) == JudgeType.Hit)
                    {
                        JudgeResult result = new JudgeResult();
                        result.correctHand = true;
                        result.type = JudgeType.Perfect;
                        note.HandleJudge(result);
                        note.Deactivate();
                        break;
                    }
                }
            }
        }
    }

    private JudgeResult Judge(PlayerInput input, Note note)
    {
        var judge = new JudgeResult();
        var hit = note.CheckHit(input);

        judge.near = false;
        judge.type = JudgeType.Ignore;
        judge.correctHand = note.HandType == HandType.None || note.HandType == input.hand;

        switch (hit)
        {
            case HitType.Hit:
                judge.type = note.JudgeTiming(input.time);
                break;
            case HitType.Near:
                if (note.JudgeTiming(input.time) >= JudgeType.Hit)
                {
                    judge.type = JudgeType.Miss;
                }
                judge.near = true;
                break;
            case HitType.Miss:
                judge.near = false;
                break;
        }

        return judge;
    }

    public void UpdateNotes(double time)
    {
        foreach (var note in notes)
        {
            float remainingTime = (float)(note.Time - time);
            note.Update(remainingTime);
        }
    }
}
