﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GunBehaviour : MonoBehaviour
{
    Animator animation;
    ParticleSystem particle;
    public LineRenderer laser;

    // Start is called before the first frame update
    void Start()
    {
        animation = GetComponentInChildren<Animator>();
        particle = GetComponentInChildren<ParticleSystem>();
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void Fire()
    {
        animation.SetTrigger("Fire");
        particle.Emit(1);
    }

    public Ray GetRay()
    {
        var pos1 = laser.transform.TransformPoint(laser.GetPosition(0));
        var pos2 = laser.transform.TransformPoint(laser.GetPosition(1));

        return new Ray(pos1, pos2 - pos1);
    }
}
