﻿using System.Collections;
using UnityEngine;
using UnityEditor;

[CustomPropertyDrawer(typeof(ReadonlyAttribute))]
public class ReadonlyDrawer : PropertyDrawer
{
    public override void OnGUI(Rect position, SerializedProperty property, GUIContent label)
    {
        GUI.enabled = false;
        switch (property.type) {
            case "Vector4":
                var v = property.vector4Value;
                EditorGUI.BeginProperty(position, label, property);
                EditorGUI.BeginChangeCheck();
                v = EditorGUI.Vector4Field(position, label, v);
                if (EditorGUI.EndChangeCheck())
                    property.vector4Value = v;
                EditorGUI.EndProperty();
                break;
            default:
                EditorGUI.PropertyField(position, property, label, true);
                break;
        }
        GUI.enabled = true;
    }
}

[CustomPropertyDrawer(typeof(Vector4))]
public class Vector4Drawer : PropertyDrawer
{
    public override void OnGUI(Rect position, SerializedProperty property, GUIContent label) {
        var v = property.vector4Value;
        EditorGUI.BeginProperty(position, label, property);
        EditorGUI.BeginChangeCheck();
        v = EditorGUI.Vector4Field(position, label, v);
        if (EditorGUI.EndChangeCheck())
            property.vector4Value = v;
        EditorGUI.EndProperty();
    }
}
