//
// Makes the value of GDATA_TARGET_NAMESPACE a prefix for all GData class names
//

//
// To avoid global namespace issues, define GDATA_TARGET_NAMESPACE to a short
// string in your target if you are using the GData library in a shared-code
// environment like a plug-in.
//
// For example:   -DGDATA_TARGET_NAMESPACE=MyPlugin
//

//
// com.google.GDataFramework v. 1.12 (555 classes) 2011-10-17 12:53:33 -0700
//

#if defined(__OBJC__) && defined(GDATA_TARGET_NAMESPACE)

  #define _GDATA_NS_SYMBOL_INNER(namespace, symbol) namespace ## _ ## symbol
  #define _GDATA_NS_SYMBOL_MIDDLE(namespace, symbol) _GDATA_NS_SYMBOL_INNER(namespace, symbol)
  #define _GDATA_NS_SYMBOL(symbol) _GDATA_NS_SYMBOL_MIDDLE(GDATA_TARGET_NAMESPACE, symbol)

  #define _GDATA_NS_STRING_INNER(namespace) #namespace
  #define _GDATA_NS_STRING_MIDDLE(namespace) _GDATA_NS_STRING_INNER(namespace)
  #define GDATA_TARGET_NAMESPACE_STRING _GDATA_NS_STRING_MIDDLE(GDATA_TARGET_NAMESPACE)

  #define GDataAccessLevelProperty                _GDATA_NS_SYMBOL(GDataAccessLevelProperty)
  #define GDataACLAdditionalRole                  _GDATA_NS_SYMBOL(GDataACLAdditionalRole)
  #define GDataACLKeyedRole                       _GDATA_NS_SYMBOL(GDataACLKeyedRole)
  #define GDataACLRole                            _GDATA_NS_SYMBOL(GDataACLRole)
  #define GDataACLRoleBase                        _GDATA_NS_SYMBOL(GDataACLRoleBase)
  #define GDataACLScope                           _GDATA_NS_SYMBOL(GDataACLScope)
  #define GDataAdditionalGuests                   _GDATA_NS_SYMBOL(GDataAdditionalGuests)
  #define GDataAnalyticsAggregateGroup            _GDATA_NS_SYMBOL(GDataAnalyticsAggregateGroup)
  #define GDataAnalyticsConstants                 _GDATA_NS_SYMBOL(GDataAnalyticsConstants)
  #define GDataAnalyticsCustomVariable            _GDATA_NS_SYMBOL(GDataAnalyticsCustomVariable)
  #define GDataAnalyticsDataSource                _GDATA_NS_SYMBOL(GDataAnalyticsDataSource)
  #define GDataAnalyticsDefinition                _GDATA_NS_SYMBOL(GDataAnalyticsDefinition)
  #define GDataAnalyticsDestination               _GDATA_NS_SYMBOL(GDataAnalyticsDestination)
  #define GDataAnalyticsDimension                 _GDATA_NS_SYMBOL(GDataAnalyticsDimension)
  #define GDataAnalyticsEndDate                   _GDATA_NS_SYMBOL(GDataAnalyticsEndDate)
  #define GDataAnalyticsEngagement                _GDATA_NS_SYMBOL(GDataAnalyticsEngagement)
  #define GDataAnalyticsGoal                      _GDATA_NS_SYMBOL(GDataAnalyticsGoal)
  #define GDataAnalyticsMetric                    _GDATA_NS_SYMBOL(GDataAnalyticsMetric)
  #define GDataAnalyticsProperty                  _GDATA_NS_SYMBOL(GDataAnalyticsProperty)
  #define GDataAnalyticsSegment                   _GDATA_NS_SYMBOL(GDataAnalyticsSegment)
  #define GDataAnalyticsStartDate                 _GDATA_NS_SYMBOL(GDataAnalyticsStartDate)
  #define GDataAnalyticsStep                      _GDATA_NS_SYMBOL(GDataAnalyticsStep)
  #define GDataAnalyticsTableID                   _GDATA_NS_SYMBOL(GDataAnalyticsTableID)
  #define GDataAnalyticsTableName                 _GDATA_NS_SYMBOL(GDataAnalyticsTableName)
  #define GDataAnyoneCanAddSelfProperty           _GDATA_NS_SYMBOL(GDataAnyoneCanAddSelfProperty)
  #define GDataAtomAccept                         _GDATA_NS_SYMBOL(GDataAtomAccept)
  #define GDataAtomAuthor                         _GDATA_NS_SYMBOL(GDataAtomAuthor)
  #define GDataAtomCategoryGroup                  _GDATA_NS_SYMBOL(GDataAtomCategoryGroup)
  #define GDataAtomCollection                     _GDATA_NS_SYMBOL(GDataAtomCollection)
  #define GDataAtomContent                        _GDATA_NS_SYMBOL(GDataAtomContent)
  #define GDataAtomContributor                    _GDATA_NS_SYMBOL(GDataAtomContributor)
  #define GDataAtomIcon                           _GDATA_NS_SYMBOL(GDataAtomIcon)
  #define GDataAtomID                             _GDATA_NS_SYMBOL(GDataAtomID)
  #define GDataAtomLogo                           _GDATA_NS_SYMBOL(GDataAtomLogo)
  #define GDataAtomPubControl                     _GDATA_NS_SYMBOL(GDataAtomPubControl)
  #define GDataAtomPubDraft                       _GDATA_NS_SYMBOL(GDataAtomPubDraft)
  #define GDataAtomPubEditedDate                  _GDATA_NS_SYMBOL(GDataAtomPubEditedDate)
  #define GDataAtomPublishedDate                  _GDATA_NS_SYMBOL(GDataAtomPublishedDate)
  #define GDataAtomRights                         _GDATA_NS_SYMBOL(GDataAtomRights)
  #define GDataAtomServiceDocument                _GDATA_NS_SYMBOL(GDataAtomServiceDocument)
  #define GDataAtomSubtitle                       _GDATA_NS_SYMBOL(GDataAtomSubtitle)
  #define GDataAtomSummary                        _GDATA_NS_SYMBOL(GDataAtomSummary)
  #define GDataAtomTitle                          _GDATA_NS_SYMBOL(GDataAtomTitle)
  #define GDataAtomUpdatedDate                    _GDATA_NS_SYMBOL(GDataAtomUpdatedDate)
  #define GDataAtomWorkspace                      _GDATA_NS_SYMBOL(GDataAtomWorkspace)
  #define GDataAttendeeStatus                     _GDATA_NS_SYMBOL(GDataAttendeeStatus)
  #define GDataAttendeeType                       _GDATA_NS_SYMBOL(GDataAttendeeType)
  #define GDataAttribute                          _GDATA_NS_SYMBOL(GDataAttribute)
  #define GDataAuthenticationFetcher              _GDATA_NS_SYMBOL(GDataAuthenticationFetcher)
  #define GDataBatchID                            _GDATA_NS_SYMBOL(GDataBatchID)
  #define GDataBatchInterrupted                   _GDATA_NS_SYMBOL(GDataBatchInterrupted)
  #define GDataBatchOperation                     _GDATA_NS_SYMBOL(GDataBatchOperation)
  #define GDataBatchStatus                        _GDATA_NS_SYMBOL(GDataBatchStatus)
  #define GDataBloggerConstants                   _GDATA_NS_SYMBOL(GDataBloggerConstants)
  #define GDataBookConstants                      _GDATA_NS_SYMBOL(GDataBookConstants)
  #define GDataBoolValueConstruct                 _GDATA_NS_SYMBOL(GDataBoolValueConstruct)
  #define GDataCalendarBusy                       _GDATA_NS_SYMBOL(GDataCalendarBusy)
  #define GDataCalendarSettingsProperty           _GDATA_NS_SYMBOL(GDataCalendarSettingsProperty)
  #define GDataCalendarTimeRange                  _GDATA_NS_SYMBOL(GDataCalendarTimeRange)
  #define GDataCalendarWhen                       _GDATA_NS_SYMBOL(GDataCalendarWhen)
  #define GDataCategory                           _GDATA_NS_SYMBOL(GDataCategory)
  #define GDataCategoryFilter                     _GDATA_NS_SYMBOL(GDataCategoryFilter)
  #define GDataCodeSearchFile                     _GDATA_NS_SYMBOL(GDataCodeSearchFile)
  #define GDataCodeSearchMatch                    _GDATA_NS_SYMBOL(GDataCodeSearchMatch)
  #define GDataCodeSearchPackage                  _GDATA_NS_SYMBOL(GDataCodeSearchPackage)
  #define GDataColorProperty                      _GDATA_NS_SYMBOL(GDataColorProperty)
  #define GDataColumnCount                        _GDATA_NS_SYMBOL(GDataColumnCount)
  #define GDataComment                            _GDATA_NS_SYMBOL(GDataComment)
  #define GDataCommission                         _GDATA_NS_SYMBOL(GDataCommission)
  #define GDataContactBillingInformation          _GDATA_NS_SYMBOL(GDataContactBillingInformation)
  #define GDataContactBirthday                    _GDATA_NS_SYMBOL(GDataContactBirthday)
  #define GDataContactCalendarLink                _GDATA_NS_SYMBOL(GDataContactCalendarLink)
  #define GDataContactConstants                   _GDATA_NS_SYMBOL(GDataContactConstants)
  #define GDataContactDirectoryServer             _GDATA_NS_SYMBOL(GDataContactDirectoryServer)
  #define GDataContactEvent                       _GDATA_NS_SYMBOL(GDataContactEvent)
  #define GDataContactExternalID                  _GDATA_NS_SYMBOL(GDataContactExternalID)
  #define GDataContactGender                      _GDATA_NS_SYMBOL(GDataContactGender)
  #define GDataContactHobby                       _GDATA_NS_SYMBOL(GDataContactHobby)
  #define GDataContactInitials                    _GDATA_NS_SYMBOL(GDataContactInitials)
  #define GDataContactJot                         _GDATA_NS_SYMBOL(GDataContactJot)
  #define GDataContactLanguage                    _GDATA_NS_SYMBOL(GDataContactLanguage)
  #define GDataContactLink                        _GDATA_NS_SYMBOL(GDataContactLink)
  #define GDataContactMaidenName                  _GDATA_NS_SYMBOL(GDataContactMaidenName)
  #define GDataContactMileage                     _GDATA_NS_SYMBOL(GDataContactMileage)
  #define GDataContactNickname                    _GDATA_NS_SYMBOL(GDataContactNickname)
  #define GDataContactOccupation                  _GDATA_NS_SYMBOL(GDataContactOccupation)
  #define GDataContactPriority                    _GDATA_NS_SYMBOL(GDataContactPriority)
  #define GDataContactRelation                    _GDATA_NS_SYMBOL(GDataContactRelation)
  #define GDataContactSensitivity                 _GDATA_NS_SYMBOL(GDataContactSensitivity)
  #define GDataContactShortName                   _GDATA_NS_SYMBOL(GDataContactShortName)
  #define GDataContactSubject                     _GDATA_NS_SYMBOL(GDataContactSubject)
  #define GDataContactSystemGroup                 _GDATA_NS_SYMBOL(GDataContactSystemGroup)
  #define GDataContactUserDefinedField            _GDATA_NS_SYMBOL(GDataContactUserDefinedField)
  #define GDataContactWebsiteLink                 _GDATA_NS_SYMBOL(GDataContactWebsiteLink)
  #define GDataContactYomiName                    _GDATA_NS_SYMBOL(GDataContactYomiName)
  #define GDataCostBasis                          _GDATA_NS_SYMBOL(GDataCostBasis)
  #define GDataCustomProperty                     _GDATA_NS_SYMBOL(GDataCustomProperty)
  #define GDataDateTime                           _GDATA_NS_SYMBOL(GDataDateTime)
  #define GDataDaysGain                           _GDATA_NS_SYMBOL(GDataDaysGain)
  #define GDataDCCreator                          _GDATA_NS_SYMBOL(GDataDCCreator)
  #define GDataDCDate                             _GDATA_NS_SYMBOL(GDataDCDate)
  #define GDataDCDescription                      _GDATA_NS_SYMBOL(GDataDCDescription)
  #define GDataDCFormat                           _GDATA_NS_SYMBOL(GDataDCFormat)
  #define GDataDCIdentifier                       _GDATA_NS_SYMBOL(GDataDCIdentifier)
  #define GDataDCLanguage                         _GDATA_NS_SYMBOL(GDataDCLanguage)
  #define GDataDCPublisher                        _GDATA_NS_SYMBOL(GDataDCPublisher)
  #define GDataDCSubject                          _GDATA_NS_SYMBOL(GDataDCSubject)
  #define GDataDCTitle                            _GDATA_NS_SYMBOL(GDataDCTitle)
  #define GDataDeleted                            _GDATA_NS_SYMBOL(GDataDeleted)
  #define GDataDocChangestamp                     _GDATA_NS_SYMBOL(GDataDocChangestamp)
  #define GDataDocConstants                       _GDATA_NS_SYMBOL(GDataDocConstants)
  #define GDataDocDescription                     _GDATA_NS_SYMBOL(GDataDocDescription)
  #define GDataDocExportFormat                    _GDATA_NS_SYMBOL(GDataDocExportFormat)
  #define GDataDocFeature                         _GDATA_NS_SYMBOL(GDataDocFeature)
  #define GDataDocFeatureName                     _GDATA_NS_SYMBOL(GDataDocFeatureName)
  #define GDataDocFeatureRate                     _GDATA_NS_SYMBOL(GDataDocFeatureRate)
  #define GDataDocFilename                        _GDATA_NS_SYMBOL(GDataDocFilename)
  #define GDataDocImportFormat                    _GDATA_NS_SYMBOL(GDataDocImportFormat)
  #define GDataDocLargestChangestamp              _GDATA_NS_SYMBOL(GDataDocLargestChangestamp)
  #define GDataDocLastCommented                   _GDATA_NS_SYMBOL(GDataDocLastCommented)
  #define GDataDocMaxUploadSize                   _GDATA_NS_SYMBOL(GDataDocMaxUploadSize)
  #define GDataDocMD5Checksum                     _GDATA_NS_SYMBOL(GDataDocMD5Checksum)
  #define GDataDocPublish                         _GDATA_NS_SYMBOL(GDataDocPublish)
  #define GDataDocPublishAuto                     _GDATA_NS_SYMBOL(GDataDocPublishAuto)
  #define GDataDocPublishOutsideDomain            _GDATA_NS_SYMBOL(GDataDocPublishOutsideDomain)
  #define GDataDocRemoved                         _GDATA_NS_SYMBOL(GDataDocRemoved)
  #define GDataDocSuggestedFilename               _GDATA_NS_SYMBOL(GDataDocSuggestedFilename)
  #define GDataDocTransferFormat                  _GDATA_NS_SYMBOL(GDataDocTransferFormat)
  #define GDataEmail                              _GDATA_NS_SYMBOL(GDataEmail)
  #define GDataEntryACL                           _GDATA_NS_SYMBOL(GDataEntryACL)
  #define GDataEntryAnalyticsAccount              _GDATA_NS_SYMBOL(GDataEntryAnalyticsAccount)
  #define GDataEntryAnalyticsData                 _GDATA_NS_SYMBOL(GDataEntryAnalyticsData)
  #define GDataEntryBase                          _GDATA_NS_SYMBOL(GDataEntryBase)
  #define GDataEntryBlog                          _GDATA_NS_SYMBOL(GDataEntryBlog)
  #define GDataEntryBlogComment                   _GDATA_NS_SYMBOL(GDataEntryBlogComment)
  #define GDataEntryBlogPost                      _GDATA_NS_SYMBOL(GDataEntryBlogPost)
  #define GDataEntryCalendar                      _GDATA_NS_SYMBOL(GDataEntryCalendar)
  #define GDataEntryCalendarEvent                 _GDATA_NS_SYMBOL(GDataEntryCalendarEvent)
  #define GDataEntryCalendarSettings              _GDATA_NS_SYMBOL(GDataEntryCalendarSettings)
  #define GDataEntryCodeSearch                    _GDATA_NS_SYMBOL(GDataEntryCodeSearch)
  #define GDataEntryCollection                    _GDATA_NS_SYMBOL(GDataEntryCollection)
  #define GDataEntryContact                       _GDATA_NS_SYMBOL(GDataEntryContact)
  #define GDataEntryContactBase                   _GDATA_NS_SYMBOL(GDataEntryContactBase)
  #define GDataEntryContactGroup                  _GDATA_NS_SYMBOL(GDataEntryContactGroup)
  #define GDataEntryContactProfile                _GDATA_NS_SYMBOL(GDataEntryContactProfile)
  #define GDataEntryContent                       _GDATA_NS_SYMBOL(GDataEntryContent)
  #define GDataEntryDocBase                       _GDATA_NS_SYMBOL(GDataEntryDocBase)
  #define GDataEntryDocChange                     _GDATA_NS_SYMBOL(GDataEntryDocChange)
  #define GDataEntryDocListMetadata               _GDATA_NS_SYMBOL(GDataEntryDocListMetadata)
  #define GDataEntryDocRevision                   _GDATA_NS_SYMBOL(GDataEntryDocRevision)
  #define GDataEntryDrawingDoc                    _GDATA_NS_SYMBOL(GDataEntryDrawingDoc)
  #define GDataEntryEvent                         _GDATA_NS_SYMBOL(GDataEntryEvent)
  #define GDataEntryFileDoc                       _GDATA_NS_SYMBOL(GDataEntryFileDoc)
  #define GDataEntryFinancePortfolio              _GDATA_NS_SYMBOL(GDataEntryFinancePortfolio)
  #define GDataEntryFinancePosition               _GDATA_NS_SYMBOL(GDataEntryFinancePosition)
  #define GDataEntryFinanceTransaction            _GDATA_NS_SYMBOL(GDataEntryFinanceTransaction)
  #define GDataEntryFolderDoc                     _GDATA_NS_SYMBOL(GDataEntryFolderDoc)
  #define GDataEntryFreeBusy                      _GDATA_NS_SYMBOL(GDataEntryFreeBusy)
  #define GDataEntryFreeBusyBase                  _GDATA_NS_SYMBOL(GDataEntryFreeBusyBase)
  #define GDataEntryGroupFreeBusy                 _GDATA_NS_SYMBOL(GDataEntryGroupFreeBusy)
  #define GDataEntryLink                          _GDATA_NS_SYMBOL(GDataEntryLink)
  #define GDataEntryMap                           _GDATA_NS_SYMBOL(GDataEntryMap)
  #define GDataEntryMapFeature                    _GDATA_NS_SYMBOL(GDataEntryMapFeature)
  #define GDataEntryMapVersion                    _GDATA_NS_SYMBOL(GDataEntryMapVersion)
  #define GDataEntryMessage                       _GDATA_NS_SYMBOL(GDataEntryMessage)
  #define GDataEntryPDFDoc                        _GDATA_NS_SYMBOL(GDataEntryPDFDoc)
  #define GDataEntryPhoto                         _GDATA_NS_SYMBOL(GDataEntryPhoto)
  #define GDataEntryPhotoAlbum                    _GDATA_NS_SYMBOL(GDataEntryPhotoAlbum)
  #define GDataEntryPhotoBase                     _GDATA_NS_SYMBOL(GDataEntryPhotoBase)
  #define GDataEntryPhotoComment                  _GDATA_NS_SYMBOL(GDataEntryPhotoComment)
  #define GDataEntryPhotoTag                      _GDATA_NS_SYMBOL(GDataEntryPhotoTag)
  #define GDataEntryPhotoUser                     _GDATA_NS_SYMBOL(GDataEntryPhotoUser)
  #define GDataEntryPresentationDoc               _GDATA_NS_SYMBOL(GDataEntryPresentationDoc)
  #define GDataEntrySite                          _GDATA_NS_SYMBOL(GDataEntrySite)
  #define GDataEntrySiteCrawlIssue                _GDATA_NS_SYMBOL(GDataEntrySiteCrawlIssue)
  #define GDataEntrySitemapBase                   _GDATA_NS_SYMBOL(GDataEntrySitemapBase)
  #define GDataEntrySitemapMobile                 _GDATA_NS_SYMBOL(GDataEntrySitemapMobile)
  #define GDataEntrySitemapNews                   _GDATA_NS_SYMBOL(GDataEntrySitemapNews)
  #define GDataEntrySitemapRegular                _GDATA_NS_SYMBOL(GDataEntrySitemapRegular)
  #define GDataEntrySiteMessage                   _GDATA_NS_SYMBOL(GDataEntrySiteMessage)
  #define GDataEntrySpreadsheet                   _GDATA_NS_SYMBOL(GDataEntrySpreadsheet)
  #define GDataEntrySpreadsheetCell               _GDATA_NS_SYMBOL(GDataEntrySpreadsheetCell)
  #define GDataEntrySpreadsheetDoc                _GDATA_NS_SYMBOL(GDataEntrySpreadsheetDoc)
  #define GDataEntrySpreadsheetList               _GDATA_NS_SYMBOL(GDataEntrySpreadsheetList)
  #define GDataEntrySpreadsheetRecord             _GDATA_NS_SYMBOL(GDataEntrySpreadsheetRecord)
  #define GDataEntrySpreadsheetTable              _GDATA_NS_SYMBOL(GDataEntrySpreadsheetTable)
  #define GDataEntryStandardDoc                   _GDATA_NS_SYMBOL(GDataEntryStandardDoc)
  #define GDataEntryVolume                        _GDATA_NS_SYMBOL(GDataEntryVolume)
  #define GDataEntryWorksheet                     _GDATA_NS_SYMBOL(GDataEntryWorksheet)
  #define GDataEntryYouTubeCaptionTrack           _GDATA_NS_SYMBOL(GDataEntryYouTubeCaptionTrack)
  #define GDataEntryYouTubeChannel                _GDATA_NS_SYMBOL(GDataEntryYouTubeChannel)
  #define GDataEntryYouTubeComment                _GDATA_NS_SYMBOL(GDataEntryYouTubeComment)
  #define GDataEntryYouTubeComplaint              _GDATA_NS_SYMBOL(GDataEntryYouTubeComplaint)
  #define GDataEntryYouTubeFavorite               _GDATA_NS_SYMBOL(GDataEntryYouTubeFavorite)
  #define GDataEntryYouTubeFeedLinkBase           _GDATA_NS_SYMBOL(GDataEntryYouTubeFeedLinkBase)
  #define GDataEntryYouTubeFriend                 _GDATA_NS_SYMBOL(GDataEntryYouTubeFriend)
  #define GDataEntryYouTubePlaylist               _GDATA_NS_SYMBOL(GDataEntryYouTubePlaylist)
  #define GDataEntryYouTubePlaylistLink           _GDATA_NS_SYMBOL(GDataEntryYouTubePlaylistLink)
  #define GDataEntryYouTubeRating                 _GDATA_NS_SYMBOL(GDataEntryYouTubeRating)
  #define GDataEntryYouTubeSubscription           _GDATA_NS_SYMBOL(GDataEntryYouTubeSubscription)
  #define GDataEntryYouTubeUpload                 _GDATA_NS_SYMBOL(GDataEntryYouTubeUpload)
  #define GDataEntryYouTubeUserEvent              _GDATA_NS_SYMBOL(GDataEntryYouTubeUserEvent)
  #define GDataEntryYouTubeUserProfile            _GDATA_NS_SYMBOL(GDataEntryYouTubeUserProfile)
  #define GDataEntryYouTubeVideo                  _GDATA_NS_SYMBOL(GDataEntryYouTubeVideo)
  #define GDataEntryYouTubeVideoMessage           _GDATA_NS_SYMBOL(GDataEntryYouTubeVideoMessage)
  #define GDataETagAttribute                      _GDATA_NS_SYMBOL(GDataETagAttribute)
  #define GDataEventStatus                        _GDATA_NS_SYMBOL(GDataEventStatus)
  #define GDataEXIFTag                            _GDATA_NS_SYMBOL(GDataEXIFTag)
  #define GDataEXIFTags                           _GDATA_NS_SYMBOL(GDataEXIFTags)
  #define GDataExtendedProperty                   _GDATA_NS_SYMBOL(GDataExtendedProperty)
  #define GDataExtensionDeclaration               _GDATA_NS_SYMBOL(GDataExtensionDeclaration)
  #define GDataFeedACL                            _GDATA_NS_SYMBOL(GDataFeedACL)
  #define GDataFeedAnalyticsAccount               _GDATA_NS_SYMBOL(GDataFeedAnalyticsAccount)
  #define GDataFeedAnalyticsData                  _GDATA_NS_SYMBOL(GDataFeedAnalyticsData)
  #define GDataFeedBase                           _GDATA_NS_SYMBOL(GDataFeedBase)
  #define GDataFeedBlog                           _GDATA_NS_SYMBOL(GDataFeedBlog)
  #define GDataFeedBlogComment                    _GDATA_NS_SYMBOL(GDataFeedBlogComment)
  #define GDataFeedBlogPost                       _GDATA_NS_SYMBOL(GDataFeedBlogPost)
  #define GDataFeedCalendar                       _GDATA_NS_SYMBOL(GDataFeedCalendar)
  #define GDataFeedCalendarEvent                  _GDATA_NS_SYMBOL(GDataFeedCalendarEvent)
  #define GDataFeedCalendarSettings               _GDATA_NS_SYMBOL(GDataFeedCalendarSettings)
  #define GDataFeedCodeSearch                     _GDATA_NS_SYMBOL(GDataFeedCodeSearch)
  #define GDataFeedCollection                     _GDATA_NS_SYMBOL(GDataFeedCollection)
  #define GDataFeedContact                        _GDATA_NS_SYMBOL(GDataFeedContact)
  #define GDataFeedContactGroup                   _GDATA_NS_SYMBOL(GDataFeedContactGroup)
  #define GDataFeedContactProfile                 _GDATA_NS_SYMBOL(GDataFeedContactProfile)
  #define GDataFeedDocChange                      _GDATA_NS_SYMBOL(GDataFeedDocChange)
  #define GDataFeedDocList                        _GDATA_NS_SYMBOL(GDataFeedDocList)
  #define GDataFeedDocRevision                    _GDATA_NS_SYMBOL(GDataFeedDocRevision)
  #define GDataFeedEvent                          _GDATA_NS_SYMBOL(GDataFeedEvent)
  #define GDataFeedFinancePortfolio               _GDATA_NS_SYMBOL(GDataFeedFinancePortfolio)
  #define GDataFeedFinancePosition                _GDATA_NS_SYMBOL(GDataFeedFinancePosition)
  #define GDataFeedFinanceTransaction             _GDATA_NS_SYMBOL(GDataFeedFinanceTransaction)
  #define GDataFeedFreeBusy                       _GDATA_NS_SYMBOL(GDataFeedFreeBusy)
  #define GDataFeedGroupFreeBusy                  _GDATA_NS_SYMBOL(GDataFeedGroupFreeBusy)
  #define GDataFeedLink                           _GDATA_NS_SYMBOL(GDataFeedLink)
  #define GDataFeedMap                            _GDATA_NS_SYMBOL(GDataFeedMap)
  #define GDataFeedMapFeature                     _GDATA_NS_SYMBOL(GDataFeedMapFeature)
  #define GDataFeedMapVersion                     _GDATA_NS_SYMBOL(GDataFeedMapVersion)
  #define GDataFeedMessage                        _GDATA_NS_SYMBOL(GDataFeedMessage)
  #define GDataFeedPhoto                          _GDATA_NS_SYMBOL(GDataFeedPhoto)
  #define GDataFeedPhotoAlbum                     _GDATA_NS_SYMBOL(GDataFeedPhotoAlbum)
  #define GDataFeedPhotoBase                      _GDATA_NS_SYMBOL(GDataFeedPhotoBase)
  #define GDataFeedPhotoUser                      _GDATA_NS_SYMBOL(GDataFeedPhotoUser)
  #define GDataFeedSite                           _GDATA_NS_SYMBOL(GDataFeedSite)
  #define GDataFeedSiteCrawlIssue                 _GDATA_NS_SYMBOL(GDataFeedSiteCrawlIssue)
  #define GDataFeedSiteKeyword                    _GDATA_NS_SYMBOL(GDataFeedSiteKeyword)
  #define GDataFeedSitemap                        _GDATA_NS_SYMBOL(GDataFeedSitemap)
  #define GDataFeedSiteMessage                    _GDATA_NS_SYMBOL(GDataFeedSiteMessage)
  #define GDataFeedSpreadsheet                    _GDATA_NS_SYMBOL(GDataFeedSpreadsheet)
  #define GDataFeedSpreadsheetCell                _GDATA_NS_SYMBOL(GDataFeedSpreadsheetCell)
  #define GDataFeedSpreadsheetList                _GDATA_NS_SYMBOL(GDataFeedSpreadsheetList)
  #define GDataFeedSpreadsheetRecord              _GDATA_NS_SYMBOL(GDataFeedSpreadsheetRecord)
  #define GDataFeedSpreadsheetTable               _GDATA_NS_SYMBOL(GDataFeedSpreadsheetTable)
  #define GDataFeedVolume                         _GDATA_NS_SYMBOL(GDataFeedVolume)
  #define GDataFeedWorksheet                      _GDATA_NS_SYMBOL(GDataFeedWorksheet)
  #define GDataFeedYouTubeCaptionTrack            _GDATA_NS_SYMBOL(GDataFeedYouTubeCaptionTrack)
  #define GDataFeedYouTubeChannel                 _GDATA_NS_SYMBOL(GDataFeedYouTubeChannel)
  #define GDataFeedYouTubeComment                 _GDATA_NS_SYMBOL(GDataFeedYouTubeComment)
  #define GDataFeedYouTubeComplaint               _GDATA_NS_SYMBOL(GDataFeedYouTubeComplaint)
  #define GDataFeedYouTubeFavorite                _GDATA_NS_SYMBOL(GDataFeedYouTubeFavorite)
  #define GDataFeedYouTubeFriend                  _GDATA_NS_SYMBOL(GDataFeedYouTubeFriend)
  #define GDataFeedYouTubePlaylist                _GDATA_NS_SYMBOL(GDataFeedYouTubePlaylist)
  #define GDataFeedYouTubePlaylistLink            _GDATA_NS_SYMBOL(GDataFeedYouTubePlaylistLink)
  #define GDataFeedYouTubeRating                  _GDATA_NS_SYMBOL(GDataFeedYouTubeRating)
  #define GDataFeedYouTubeSubscription            _GDATA_NS_SYMBOL(GDataFeedYouTubeSubscription)
  #define GDataFeedYouTubeUserEvent               _GDATA_NS_SYMBOL(GDataFeedYouTubeUserEvent)
  #define GDataFeedYouTubeUserProfile             _GDATA_NS_SYMBOL(GDataFeedYouTubeUserProfile)
  #define GDataFeedYouTubeVideo                   _GDATA_NS_SYMBOL(GDataFeedYouTubeVideo)
  #define GDataFeedYouTubeVideoMessage            _GDATA_NS_SYMBOL(GDataFeedYouTubeVideoMessage)
  #define GDataFieldsAttribute                    _GDATA_NS_SYMBOL(GDataFieldsAttribute)
  #define GDataFinanceSymbol                      _GDATA_NS_SYMBOL(GDataFinanceSymbol)
  #define GDataFinanceTransactionData             _GDATA_NS_SYMBOL(GDataFinanceTransactionData)
  #define GDataGain                               _GDATA_NS_SYMBOL(GDataGain)
  #define GDataGenerator                          _GDATA_NS_SYMBOL(GDataGenerator)
  #define GDataGeo                                _GDATA_NS_SYMBOL(GDataGeo)
  #define GDataGeoPt                              _GDATA_NS_SYMBOL(GDataGeoPt)
  #define GDataGeoRSSFeatureName                  _GDATA_NS_SYMBOL(GDataGeoRSSFeatureName)
  #define GDataGeoRSSPoint                        _GDATA_NS_SYMBOL(GDataGeoRSSPoint)
  #define GDataGeoRSSRadius                       _GDATA_NS_SYMBOL(GDataGeoRSSRadius)
  #define GDataGeoRSSWhere                        _GDATA_NS_SYMBOL(GDataGeoRSSWhere)
  #define GDataGeoW3CPoint                        _GDATA_NS_SYMBOL(GDataGeoW3CPoint)
  #define GDataGroupMembershipInfo                _GDATA_NS_SYMBOL(GDataGroupMembershipInfo)
  #define GDataGuestsCanInviteOthersProperty      _GDATA_NS_SYMBOL(GDataGuestsCanInviteOthersProperty)
  #define GDataGuestsCanModifyProperty            _GDATA_NS_SYMBOL(GDataGuestsCanModifyProperty)
  #define GDataGuestsCanSeeGuestsProperty         _GDATA_NS_SYMBOL(GDataGuestsCanSeeGuestsProperty)
  #define GDataHiddenProperty                     _GDATA_NS_SYMBOL(GDataHiddenProperty)
  #define GDataICalUIDProperty                    _GDATA_NS_SYMBOL(GDataICalUIDProperty)
  #define GDataIM                                 _GDATA_NS_SYMBOL(GDataIM)
  #define GDataImplicitValueConstruct             _GDATA_NS_SYMBOL(GDataImplicitValueConstruct)
  #define GDataInReplyTo                          _GDATA_NS_SYMBOL(GDataInReplyTo)
  #define GDataKindAttribute                      _GDATA_NS_SYMBOL(GDataKindAttribute)
  #define GDataLastModifiedBy                     _GDATA_NS_SYMBOL(GDataLastModifiedBy)
  #define GDataLastViewed                         _GDATA_NS_SYMBOL(GDataLastViewed)
  #define GDataLink                               _GDATA_NS_SYMBOL(GDataLink)
  #define GDataMapConstants                       _GDATA_NS_SYMBOL(GDataMapConstants)
  #define GDataMarketValue                        _GDATA_NS_SYMBOL(GDataMarketValue)
  #define GDataMediaCategory                      _GDATA_NS_SYMBOL(GDataMediaCategory)
  #define GDataMediaContent                       _GDATA_NS_SYMBOL(GDataMediaContent)
  #define GDataMediaCredit                        _GDATA_NS_SYMBOL(GDataMediaCredit)
  #define GDataMediaDescription                   _GDATA_NS_SYMBOL(GDataMediaDescription)
  #define GDataMediaGroup                         _GDATA_NS_SYMBOL(GDataMediaGroup)
  #define GDataMediaKeywords                      _GDATA_NS_SYMBOL(GDataMediaKeywords)
  #define GDataMediaPlayer                        _GDATA_NS_SYMBOL(GDataMediaPlayer)
  #define GDataMediaRating                        _GDATA_NS_SYMBOL(GDataMediaRating)
  #define GDataMediaRestriction                   _GDATA_NS_SYMBOL(GDataMediaRestriction)
  #define GDataMediaThumbnail                     _GDATA_NS_SYMBOL(GDataMediaThumbnail)
  #define GDataMediaTitle                         _GDATA_NS_SYMBOL(GDataMediaTitle)
  #define GDataMoney                              _GDATA_NS_SYMBOL(GDataMoney)
  #define GDataMoneyElementBase                   _GDATA_NS_SYMBOL(GDataMoneyElementBase)
  #define GDataName                               _GDATA_NS_SYMBOL(GDataName)
  #define GDataNameAdditional                     _GDATA_NS_SYMBOL(GDataNameAdditional)
  #define GDataNameElement                        _GDATA_NS_SYMBOL(GDataNameElement)
  #define GDataNameFamily                         _GDATA_NS_SYMBOL(GDataNameFamily)
  #define GDataNameFull                           _GDATA_NS_SYMBOL(GDataNameFull)
  #define GDataNameGiven                          _GDATA_NS_SYMBOL(GDataNameGiven)
  #define GDataNamePrefix                         _GDATA_NS_SYMBOL(GDataNamePrefix)
  #define GDataNameSuffix                         _GDATA_NS_SYMBOL(GDataNameSuffix)
  #define GDataNameValueConstruct                 _GDATA_NS_SYMBOL(GDataNameValueConstruct)
  #define GDataNormalPlayTime                     _GDATA_NS_SYMBOL(GDataNormalPlayTime)
  #define GDataObject                             _GDATA_NS_SYMBOL(GDataObject)
  #define GDataOpenSearchItemsPerPage             _GDATA_NS_SYMBOL(GDataOpenSearchItemsPerPage)
  #define GDataOpenSearchStartIndex               _GDATA_NS_SYMBOL(GDataOpenSearchStartIndex)
  #define GDataOpenSearchTotalResults             _GDATA_NS_SYMBOL(GDataOpenSearchTotalResults)
  #define GDataOrganization                       _GDATA_NS_SYMBOL(GDataOrganization)
  #define GDataOrganizationName                   _GDATA_NS_SYMBOL(GDataOrganizationName)
  #define GDataOrgDepartment                      _GDATA_NS_SYMBOL(GDataOrgDepartment)
  #define GDataOrgJobDescription                  _GDATA_NS_SYMBOL(GDataOrgJobDescription)
  #define GDataOrgSymbol                          _GDATA_NS_SYMBOL(GDataOrgSymbol)
  #define GDataOrgTitle                           _GDATA_NS_SYMBOL(GDataOrgTitle)
  #define GDataOriginalEvent                      _GDATA_NS_SYMBOL(GDataOriginalEvent)
  #define GDataOverrideNameProperty               _GDATA_NS_SYMBOL(GDataOverrideNameProperty)
  #define GDataPerson                             _GDATA_NS_SYMBOL(GDataPerson)
  #define GDataPersonEmail                        _GDATA_NS_SYMBOL(GDataPersonEmail)
  #define GDataPersonName                         _GDATA_NS_SYMBOL(GDataPersonName)
  #define GDataPersonURI                          _GDATA_NS_SYMBOL(GDataPersonURI)
  #define GDataPhoneNumber                        _GDATA_NS_SYMBOL(GDataPhoneNumber)
  #define GDataPhotoAccess                        _GDATA_NS_SYMBOL(GDataPhotoAccess)
  #define GDataPhotoAlbumDesc                     _GDATA_NS_SYMBOL(GDataPhotoAlbumDesc)
  #define GDataPhotoAlbumID                       _GDATA_NS_SYMBOL(GDataPhotoAlbumID)
  #define GDataPhotoAlbumTitle                    _GDATA_NS_SYMBOL(GDataPhotoAlbumTitle)
  #define GDataPhotoBytesUsed                     _GDATA_NS_SYMBOL(GDataPhotoBytesUsed)
  #define GDataPhotoChecksum                      _GDATA_NS_SYMBOL(GDataPhotoChecksum)
  #define GDataPhotoCommentCount                  _GDATA_NS_SYMBOL(GDataPhotoCommentCount)
  #define GDataPhotoCommentingEnabled             _GDATA_NS_SYMBOL(GDataPhotoCommentingEnabled)
  #define GDataPhotoConstants                     _GDATA_NS_SYMBOL(GDataPhotoConstants)
  #define GDataPhotoGPhotoID                      _GDATA_NS_SYMBOL(GDataPhotoGPhotoID)
  #define GDataPhotoHeight                        _GDATA_NS_SYMBOL(GDataPhotoHeight)
  #define GDataPhotoLocation                      _GDATA_NS_SYMBOL(GDataPhotoLocation)
  #define GDataPhotoMaxPhotosPerAlbum             _GDATA_NS_SYMBOL(GDataPhotoMaxPhotosPerAlbum)
  #define GDataPhotoNickname                      _GDATA_NS_SYMBOL(GDataPhotoNickname)
  #define GDataPhotoNumberLeft                    _GDATA_NS_SYMBOL(GDataPhotoNumberLeft)
  #define GDataPhotoNumberUsed                    _GDATA_NS_SYMBOL(GDataPhotoNumberUsed)
  #define GDataPhotoPhotoID                       _GDATA_NS_SYMBOL(GDataPhotoPhotoID)
  #define GDataPhotoQuotaLimit                    _GDATA_NS_SYMBOL(GDataPhotoQuotaLimit)
  #define GDataPhotoQuotaUsed                     _GDATA_NS_SYMBOL(GDataPhotoQuotaUsed)
  #define GDataPhotoRotation                      _GDATA_NS_SYMBOL(GDataPhotoRotation)
  #define GDataPhotoSize                          _GDATA_NS_SYMBOL(GDataPhotoSize)
  #define GDataPhotoSnippet                       _GDATA_NS_SYMBOL(GDataPhotoSnippet)
  #define GDataPhotoSnippetType                   _GDATA_NS_SYMBOL(GDataPhotoSnippetType)
  #define GDataPhotoThumbnail                     _GDATA_NS_SYMBOL(GDataPhotoThumbnail)
  #define GDataPhotoTimestamp                     _GDATA_NS_SYMBOL(GDataPhotoTimestamp)
  #define GDataPhotoTruncated                     _GDATA_NS_SYMBOL(GDataPhotoTruncated)
  #define GDataPhotoUser                          _GDATA_NS_SYMBOL(GDataPhotoUser)
  #define GDataPhotoVideoStatus                   _GDATA_NS_SYMBOL(GDataPhotoVideoStatus)
  #define GDataPhotoWeight                        _GDATA_NS_SYMBOL(GDataPhotoWeight)
  #define GDataPhotoWidth                         _GDATA_NS_SYMBOL(GDataPhotoWidth)
  #define GDataPortfolioBase                      _GDATA_NS_SYMBOL(GDataPortfolioBase)
  #define GDataPortfolioData                      _GDATA_NS_SYMBOL(GDataPortfolioData)
  #define GDataPositionData                       _GDATA_NS_SYMBOL(GDataPositionData)
  #define GDataPostalAddress                      _GDATA_NS_SYMBOL(GDataPostalAddress)
  #define GDataPostalAddressAgent                 _GDATA_NS_SYMBOL(GDataPostalAddressAgent)
  #define GDataPostalAddressCity                  _GDATA_NS_SYMBOL(GDataPostalAddressCity)
  #define GDataPostalAddressCountry               _GDATA_NS_SYMBOL(GDataPostalAddressCountry)
  #define GDataPostalAddressFormattedAddress      _GDATA_NS_SYMBOL(GDataPostalAddressFormattedAddress)
  #define GDataPostalAddressHouseName             _GDATA_NS_SYMBOL(GDataPostalAddressHouseName)
  #define GDataPostalAddressNeighborhood          _GDATA_NS_SYMBOL(GDataPostalAddressNeighborhood)
  #define GDataPostalAddressPOBox                 _GDATA_NS_SYMBOL(GDataPostalAddressPOBox)
  #define GDataPostalAddressPostCode              _GDATA_NS_SYMBOL(GDataPostalAddressPostCode)
  #define GDataPostalAddressRegion                _GDATA_NS_SYMBOL(GDataPostalAddressRegion)
  #define GDataPostalAddressStreet                _GDATA_NS_SYMBOL(GDataPostalAddressStreet)
  #define GDataPostalAddressSubregion             _GDATA_NS_SYMBOL(GDataPostalAddressSubregion)
  #define GDataPrice                              _GDATA_NS_SYMBOL(GDataPrice)
  #define GDataPrivateCopyProperty                _GDATA_NS_SYMBOL(GDataPrivateCopyProperty)
  #define GDataQuery                              _GDATA_NS_SYMBOL(GDataQuery)
  #define GDataQueryAnalytics                     _GDATA_NS_SYMBOL(GDataQueryAnalytics)
  #define GDataQueryBooks                         _GDATA_NS_SYMBOL(GDataQueryBooks)
  #define GDataQueryCalendar                      _GDATA_NS_SYMBOL(GDataQueryCalendar)
  #define GDataQueryContact                       _GDATA_NS_SYMBOL(GDataQueryContact)
  #define GDataQueryDocs                          _GDATA_NS_SYMBOL(GDataQueryDocs)
  #define GDataQueryFinance                       _GDATA_NS_SYMBOL(GDataQueryFinance)
  #define GDataQueryGooglePhotos                  _GDATA_NS_SYMBOL(GDataQueryGooglePhotos)
  #define GDataQueryMaps                          _GDATA_NS_SYMBOL(GDataQueryMaps)
  #define GDataQuerySpreadsheet                   _GDATA_NS_SYMBOL(GDataQuerySpreadsheet)
  #define GDataQueryYouTube                       _GDATA_NS_SYMBOL(GDataQueryYouTube)
  #define GDataQuickAddProperty                   _GDATA_NS_SYMBOL(GDataQuickAddProperty)
  #define GDataQuotaBytesTotal                    _GDATA_NS_SYMBOL(GDataQuotaBytesTotal)
  #define GDataQuotaBytesUsed                     _GDATA_NS_SYMBOL(GDataQuotaBytesUsed)
  #define GDataQuotaBytesUsedInTrash              _GDATA_NS_SYMBOL(GDataQuotaBytesUsedInTrash)
  #define GDataRating                             _GDATA_NS_SYMBOL(GDataRating)
  #define GDataRecurrence                         _GDATA_NS_SYMBOL(GDataRecurrence)
  #define GDataRecurrenceException                _GDATA_NS_SYMBOL(GDataRecurrenceException)
  #define GDataReminder                           _GDATA_NS_SYMBOL(GDataReminder)
  #define GDataResourceID                         _GDATA_NS_SYMBOL(GDataResourceID)
  #define GDataResourceProperty                   _GDATA_NS_SYMBOL(GDataResourceProperty)
  #define GDataRowColumnCount                     _GDATA_NS_SYMBOL(GDataRowColumnCount)
  #define GDataRowCount                           _GDATA_NS_SYMBOL(GDataRowCount)
  #define GDataSelectedProperty                   _GDATA_NS_SYMBOL(GDataSelectedProperty)
  #define GDataSendEventNotifications             _GDATA_NS_SYMBOL(GDataSendEventNotifications)
  #define GDataSequenceProperty                   _GDATA_NS_SYMBOL(GDataSequenceProperty)
  #define GDataServerError                        _GDATA_NS_SYMBOL(GDataServerError)
  #define GDataServerErrorGroup                   _GDATA_NS_SYMBOL(GDataServerErrorGroup)
  #define GDataServiceBase                        _GDATA_NS_SYMBOL(GDataServiceBase)
  #define GDataServiceGoogle                      _GDATA_NS_SYMBOL(GDataServiceGoogle)
  #define GDataServiceGoogleAnalytics             _GDATA_NS_SYMBOL(GDataServiceGoogleAnalytics)
  #define GDataServiceGoogleBlogger               _GDATA_NS_SYMBOL(GDataServiceGoogleBlogger)
  #define GDataServiceGoogleBooks                 _GDATA_NS_SYMBOL(GDataServiceGoogleBooks)
  #define GDataServiceGoogleCalendar              _GDATA_NS_SYMBOL(GDataServiceGoogleCalendar)
  #define GDataServiceGoogleContact               _GDATA_NS_SYMBOL(GDataServiceGoogleContact)
  #define GDataServiceGoogleDocs                  _GDATA_NS_SYMBOL(GDataServiceGoogleDocs)
  #define GDataServiceGoogleFinance               _GDATA_NS_SYMBOL(GDataServiceGoogleFinance)
  #define GDataServiceGoogleMaps                  _GDATA_NS_SYMBOL(GDataServiceGoogleMaps)
  #define GDataServiceGooglePhotos                _GDATA_NS_SYMBOL(GDataServiceGooglePhotos)
  #define GDataServiceGoogleSpreadsheet           _GDATA_NS_SYMBOL(GDataServiceGoogleSpreadsheet)
  #define GDataServiceGoogleWebmasterTools        _GDATA_NS_SYMBOL(GDataServiceGoogleWebmasterTools)
  #define GDataServiceGoogleYouTube               _GDATA_NS_SYMBOL(GDataServiceGoogleYouTube)
  #define GDataServiceTicket                      _GDATA_NS_SYMBOL(GDataServiceTicket)
  #define GDataServiceTicketBase                  _GDATA_NS_SYMBOL(GDataServiceTicketBase)
  #define GDataSiteCrawledDate                    _GDATA_NS_SYMBOL(GDataSiteCrawledDate)
  #define GDataSiteCrawlIssueDateDetected         _GDATA_NS_SYMBOL(GDataSiteCrawlIssueDateDetected)
  #define GDataSiteCrawlIssueDetail               _GDATA_NS_SYMBOL(GDataSiteCrawlIssueDetail)
  #define GDataSiteCrawlIssueLinkedFrom           _GDATA_NS_SYMBOL(GDataSiteCrawlIssueLinkedFrom)
  #define GDataSiteCrawlIssueType                 _GDATA_NS_SYMBOL(GDataSiteCrawlIssueType)
  #define GDataSiteCrawlIssueURL                  _GDATA_NS_SYMBOL(GDataSiteCrawlIssueURL)
  #define GDataSiteCrawlRate                      _GDATA_NS_SYMBOL(GDataSiteCrawlRate)
  #define GDataSiteCrawlType                      _GDATA_NS_SYMBOL(GDataSiteCrawlType)
  #define GDataSiteEnhancedImageSearch            _GDATA_NS_SYMBOL(GDataSiteEnhancedImageSearch)
  #define GDataSiteGeoLocation                    _GDATA_NS_SYMBOL(GDataSiteGeoLocation)
  #define GDataSiteIndexed                        _GDATA_NS_SYMBOL(GDataSiteIndexed)
  #define GDataSiteKeyword                        _GDATA_NS_SYMBOL(GDataSiteKeyword)
  #define GDataSitemapLastDownloaded              _GDATA_NS_SYMBOL(GDataSitemapLastDownloaded)
  #define GDataSitemapMarkupLanguage              _GDATA_NS_SYMBOL(GDataSitemapMarkupLanguage)
  #define GDataSitemapMobile                      _GDATA_NS_SYMBOL(GDataSitemapMobile)
  #define GDataSitemapMobileMarkupLanguage        _GDATA_NS_SYMBOL(GDataSitemapMobileMarkupLanguage)
  #define GDataSitemapNews                        _GDATA_NS_SYMBOL(GDataSitemapNews)
  #define GDataSitemapNewsPublicationLabel        _GDATA_NS_SYMBOL(GDataSitemapNewsPublicationLabel)
  #define GDataSitemapPublicationLabel            _GDATA_NS_SYMBOL(GDataSitemapPublicationLabel)
  #define GDataSitemapStatus                      _GDATA_NS_SYMBOL(GDataSitemapStatus)
  #define GDataSitemapType                        _GDATA_NS_SYMBOL(GDataSitemapType)
  #define GDataSitemapURLCount                    _GDATA_NS_SYMBOL(GDataSitemapURLCount)
  #define GDataSiteMessageBody                    _GDATA_NS_SYMBOL(GDataSiteMessageBody)
  #define GDataSiteMessageDate                    _GDATA_NS_SYMBOL(GDataSiteMessageDate)
  #define GDataSiteMessageLanguage                _GDATA_NS_SYMBOL(GDataSiteMessageLanguage)
  #define GDataSiteMessageRead                    _GDATA_NS_SYMBOL(GDataSiteMessageRead)
  #define GDataSiteMessageSubject                 _GDATA_NS_SYMBOL(GDataSiteMessageSubject)
  #define GDataSitePreferredDomain                _GDATA_NS_SYMBOL(GDataSitePreferredDomain)
  #define GDataSiteVerificationMethod             _GDATA_NS_SYMBOL(GDataSiteVerificationMethod)
  #define GDataSiteVerified                       _GDATA_NS_SYMBOL(GDataSiteVerified)
  #define GDataSpreadsheetCell                    _GDATA_NS_SYMBOL(GDataSpreadsheetCell)
  #define GDataSpreadsheetColumn                  _GDATA_NS_SYMBOL(GDataSpreadsheetColumn)
  #define GDataSpreadsheetConstants               _GDATA_NS_SYMBOL(GDataSpreadsheetConstants)
  #define GDataSpreadsheetCustomElement           _GDATA_NS_SYMBOL(GDataSpreadsheetCustomElement)
  #define GDataSpreadsheetData                    _GDATA_NS_SYMBOL(GDataSpreadsheetData)
  #define GDataSpreadsheetField                   _GDATA_NS_SYMBOL(GDataSpreadsheetField)
  #define GDataSpreadsheetHeader                  _GDATA_NS_SYMBOL(GDataSpreadsheetHeader)
  #define GDataStructuredPostalAddress            _GDATA_NS_SYMBOL(GDataStructuredPostalAddress)
  #define GDataSuppressReplyNotificationsProperty _GDATA_NS_SYMBOL(GDataSuppressReplyNotificationsProperty)
  #define GDataSyncEventProperty                  _GDATA_NS_SYMBOL(GDataSyncEventProperty)
  #define GDataTextConstruct                      _GDATA_NS_SYMBOL(GDataTextConstruct)
  #define GDataThreadingCount                     _GDATA_NS_SYMBOL(GDataThreadingCount)
  #define GDataThreadingLink                      _GDATA_NS_SYMBOL(GDataThreadingLink)
  #define GDataThreadingTotal                     _GDATA_NS_SYMBOL(GDataThreadingTotal)
  #define GDataThreadingUpdated                   _GDATA_NS_SYMBOL(GDataThreadingUpdated)
  #define GDataTimesCleanedProperty               _GDATA_NS_SYMBOL(GDataTimesCleanedProperty)
  #define GDataTimeZoneProperty                   _GDATA_NS_SYMBOL(GDataTimeZoneProperty)
  #define GDataTransparency                       _GDATA_NS_SYMBOL(GDataTransparency)
  #define GDataUtilities                          _GDATA_NS_SYMBOL(GDataUtilities)
  #define GDataValueConstruct                     _GDATA_NS_SYMBOL(GDataValueConstruct)
  #define GDataValueElementConstruct              _GDATA_NS_SYMBOL(GDataValueElementConstruct)
  #define GDataVisibility                         _GDATA_NS_SYMBOL(GDataVisibility)
  #define GDataVolumeContentVersion               _GDATA_NS_SYMBOL(GDataVolumeContentVersion)
  #define GDataVolumeEmbeddability                _GDATA_NS_SYMBOL(GDataVolumeEmbeddability)
  #define GDataVolumeOpenAccess                   _GDATA_NS_SYMBOL(GDataVolumeOpenAccess)
  #define GDataVolumePrice                        _GDATA_NS_SYMBOL(GDataVolumePrice)
  #define GDataVolumePromotion                    _GDATA_NS_SYMBOL(GDataVolumePromotion)
  #define GDataVolumeReadingPosition              _GDATA_NS_SYMBOL(GDataVolumeReadingPosition)
  #define GDataVolumeReview                       _GDATA_NS_SYMBOL(GDataVolumeReview)
  #define GDataVolumeViewability                  _GDATA_NS_SYMBOL(GDataVolumeViewability)
  #define GDataWebContent                         _GDATA_NS_SYMBOL(GDataWebContent)
  #define GDataWebContentGadgetPref               _GDATA_NS_SYMBOL(GDataWebContentGadgetPref)
  #define GDataWebmasterToolsConstants            _GDATA_NS_SYMBOL(GDataWebmasterToolsConstants)
  #define GDataWhen                               _GDATA_NS_SYMBOL(GDataWhen)
  #define GDataWhere                              _GDATA_NS_SYMBOL(GDataWhere)
  #define GDataWho                                _GDATA_NS_SYMBOL(GDataWho)
  #define GDataWorksheetName                      _GDATA_NS_SYMBOL(GDataWorksheetName)
  #define GDataWritersCanInvite                   _GDATA_NS_SYMBOL(GDataWritersCanInvite)
  #define GDataYouTubeAboutMe                     _GDATA_NS_SYMBOL(GDataYouTubeAboutMe)
  #define GDataYouTubeAccessControl               _GDATA_NS_SYMBOL(GDataYouTubeAccessControl)
  #define GDataYouTubeAge                         _GDATA_NS_SYMBOL(GDataYouTubeAge)
  #define GDataYouTubeAspectRatio                 _GDATA_NS_SYMBOL(GDataYouTubeAspectRatio)
  #define GDataYouTubeBooks                       _GDATA_NS_SYMBOL(GDataYouTubeBooks)
  #define GDataYouTubeCommentRating               _GDATA_NS_SYMBOL(GDataYouTubeCommentRating)
  #define GDataYouTubeCompany                     _GDATA_NS_SYMBOL(GDataYouTubeCompany)
  #define GDataYouTubeConstants                   _GDATA_NS_SYMBOL(GDataYouTubeConstants)
  #define GDataYouTubeCountHint                   _GDATA_NS_SYMBOL(GDataYouTubeCountHint)
  #define GDataYouTubeCountryAttribute            _GDATA_NS_SYMBOL(GDataYouTubeCountryAttribute)
  #define GDataYouTubeDerived                     _GDATA_NS_SYMBOL(GDataYouTubeDerived)
  #define GDataYouTubeDuration                    _GDATA_NS_SYMBOL(GDataYouTubeDuration)
  #define GDataYouTubeFirstName                   _GDATA_NS_SYMBOL(GDataYouTubeFirstName)
  #define GDataYouTubeFormatAttribute             _GDATA_NS_SYMBOL(GDataYouTubeFormatAttribute)
  #define GDataYouTubeGender                      _GDATA_NS_SYMBOL(GDataYouTubeGender)
  #define GDataYouTubeHobbies                     _GDATA_NS_SYMBOL(GDataYouTubeHobbies)
  #define GDataYouTubeHometown                    _GDATA_NS_SYMBOL(GDataYouTubeHometown)
  #define GDataYouTubeIncomplete                  _GDATA_NS_SYMBOL(GDataYouTubeIncomplete)
  #define GDataYouTubeLastName                    _GDATA_NS_SYMBOL(GDataYouTubeLastName)
  #define GDataYouTubeLocation                    _GDATA_NS_SYMBOL(GDataYouTubeLocation)
  #define GDataYouTubeMediaGroup                  _GDATA_NS_SYMBOL(GDataYouTubeMediaGroup)
  #define GDataYouTubeMovies                      _GDATA_NS_SYMBOL(GDataYouTubeMovies)
  #define GDataYouTubeMusic                       _GDATA_NS_SYMBOL(GDataYouTubeMusic)
  #define GDataYouTubeNameAttribute               _GDATA_NS_SYMBOL(GDataYouTubeNameAttribute)
  #define GDataYouTubeNonEmbeddable               _GDATA_NS_SYMBOL(GDataYouTubeNonEmbeddable)
  #define GDataYouTubeOccupation                  _GDATA_NS_SYMBOL(GDataYouTubeOccupation)
  #define GDataYouTubePlaylistID                  _GDATA_NS_SYMBOL(GDataYouTubePlaylistID)
  #define GDataYouTubePlaylistTitle               _GDATA_NS_SYMBOL(GDataYouTubePlaylistTitle)
  #define GDataYouTubePosition                    _GDATA_NS_SYMBOL(GDataYouTubePosition)
  #define GDataYouTubePrivate                     _GDATA_NS_SYMBOL(GDataYouTubePrivate)
  #define GDataYouTubePublicationState            _GDATA_NS_SYMBOL(GDataYouTubePublicationState)
  #define GDataYouTubeQueryString                 _GDATA_NS_SYMBOL(GDataYouTubeQueryString)
  #define GDataYouTubeRating                      _GDATA_NS_SYMBOL(GDataYouTubeRating)
  #define GDataYouTubeRecordedDate                _GDATA_NS_SYMBOL(GDataYouTubeRecordedDate)
  #define GDataYouTubeRelationship                _GDATA_NS_SYMBOL(GDataYouTubeRelationship)
  #define GDataYouTubeSchool                      _GDATA_NS_SYMBOL(GDataYouTubeSchool)
  #define GDataYouTubeSpam                        _GDATA_NS_SYMBOL(GDataYouTubeSpam)
  #define GDataYouTubeStatistics                  _GDATA_NS_SYMBOL(GDataYouTubeStatistics)
  #define GDataYouTubeStatus                      _GDATA_NS_SYMBOL(GDataYouTubeStatus)
  #define GDataYouTubeToken                       _GDATA_NS_SYMBOL(GDataYouTubeToken)
  #define GDataYouTubeTypeAttribute               _GDATA_NS_SYMBOL(GDataYouTubeTypeAttribute)
  #define GDataYouTubeUploadedDate                _GDATA_NS_SYMBOL(GDataYouTubeUploadedDate)
  #define GDataYouTubeUsername                    _GDATA_NS_SYMBOL(GDataYouTubeUsername)
  #define GDataYouTubeVideoID                     _GDATA_NS_SYMBOL(GDataYouTubeVideoID)
  #define GTMCachedURLResponse                    _GDATA_NS_SYMBOL(GTMCachedURLResponse)
  #define GTMCookieStorage                        _GDATA_NS_SYMBOL(GTMCookieStorage)
  #define GTMGatherInputStream                    _GDATA_NS_SYMBOL(GTMGatherInputStream)
  #define GTMHTTPFetcher                          _GDATA_NS_SYMBOL(GTMHTTPFetcher)
  #define GTMHTTPFetcherService                   _GDATA_NS_SYMBOL(GTMHTTPFetcherService)
  #define GTMHTTPFetchHistory                     _GDATA_NS_SYMBOL(GTMHTTPFetchHistory)
  #define GTMHTTPUploadFetcher                    _GDATA_NS_SYMBOL(GTMHTTPUploadFetcher)
  #define GTMMIMEDocument                         _GDATA_NS_SYMBOL(GTMMIMEDocument)
  #define GTMMIMEPart                             _GDATA_NS_SYMBOL(GTMMIMEPart)
  #define GTMOAuth2Authentication                 _GDATA_NS_SYMBOL(GTMOAuth2Authentication)
  #define GTMOAuth2AuthorizationArgs              _GDATA_NS_SYMBOL(GTMOAuth2AuthorizationArgs)
  #define GTMOAuth2SignIn                         _GDATA_NS_SYMBOL(GTMOAuth2SignIn)
  #define GTMOAuth2WindowController               _GDATA_NS_SYMBOL(GTMOAuth2WindowController)
  #define GTMReadMonitorInputStream               _GDATA_NS_SYMBOL(GTMReadMonitorInputStream)
  #define GTMURLCache                             _GDATA_NS_SYMBOL(GTMURLCache)

#endif
