/********************************************************************
 *                    COPYRIGHT PARROT 2010
 ********************************************************************
 *       PARROT - A.R.Drone SDK Windows Client Example
 *-----------------------------------------------------------------*/
/**
 * @file custom_code.c 
 * @brief User added code
 *
 * @author sylvain.gaeremynck@parrot.com
 * @date 2009/07/01
 *
 * @author Stephane Piskorski <stephane.piskorski.ext@parrot.fr>
 * @date   Sept, 8. 2010
 *
 *******************************************************************/



#include <custom_code.h>

//ARDroneLib
	#include <utils/ardrone_time.h>
	#include <ardrone_tool/Navdata/ardrone_navdata_client.h>
	#include <ardrone_tool/Control/ardrone_control.h>
	#include <ardrone_tool/UI/ardrone_input.h>

//Common
	#include <config.h>
	#include <ardrone_api.h>

//VP_SDK
	#include <ATcodec/ATcodec_api.h>
	#include <VP_Os/vp_os_print.h>
	#include <VP_Api/vp_api_thread_helper.h>
	#include <VP_Os/vp_os_signal.h>

//Local project
	#include <UI/gamepad.h>
	#include <Video/video_stage.h>
	#include <UI/directx_rendering.h>

//Global variables
	int32_t exit_ihm_program = 1;
	vp_os_mutex_t consoleMutex;


/* Implementing Custom methods for the main function of an ARDrone application */
int main(int argc, char** argv)
{
	return ardrone_tool_main(argc, argv);
}

/*--------------------------------------------------------------------
The delegate object calls this method during initialization of an 
ARDrone application 
--------------------------------------------------------------------*/
C_RESULT ardrone_tool_init_custom(void)
{
	/* Change the console title */
		vp_os_mutex_init(&consoleMutex);
		system("cls");
		SetConsoleTitle(TEXT("Parrot A.R. Drone SDK Demo for Windows"));
		//CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&HmiStart,NULL,0,0);
		//CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&HmiStart2,NULL,0,0);


	/* Registering for a new device of game controller */
		ardrone_tool_input_add( &dx_keyboard );
		ardrone_tool_input_add( &dx_gamepad );
	
	/* Start all threads of your application */
		START_THREAD( directx_renderer_thread , NULL);
		START_THREAD( video_stage, NULL );

		
  
  return C_OK;
}



/*--------------------------------------------------------------------
The delegate object calls this method when the event loop exit     
--------------------------------------------------------------------*/
C_RESULT ardrone_tool_shutdown_custom()
{
  /* Relinquish all threads of your application */
  JOIN_THREAD( video_stage );

  /* Unregistering for the current device */
  ardrone_tool_input_remove( &dx_gamepad );
  ardrone_tool_input_remove( &dx_keyboard );

  /* Mutex needs to be destroyed but may still be used by navdata thread */
  /* todo : synchronize threads shutdown */
  //vp_os_mutex_destroy(&consoleMutex);

  return C_OK;
}

/*--------------------------------------------------------------------
The event loop calls this method for the exit condition            
--------------------------------------------------------------------*/
bool_t ardrone_tool_exit()
{
  return exit_ihm_program == 0;
}

C_RESULT signal_exit()
{
  exit_ihm_program = 0;

  return C_OK;
}

/* Implementing thread table in which you add routines of your application and those provided by the SDK */
BEGIN_THREAD_TABLE
  THREAD_TABLE_ENTRY( ardrone_control, 20 )
  THREAD_TABLE_ENTRY( navdata_update, 20 )
  THREAD_TABLE_ENTRY( video_stage, 20 )
  THREAD_TABLE_ENTRY( directx_renderer_thread, 20 )
END_THREAD_TABLE



/* Function to change the cursor place in the console window */

	HANDLE hStdout =  NULL;  /* Handle to the output console */
	CONSOLE_SCREEN_BUFFER_INFO csbiInfo;				/* Information about the output console */



void ARWin32Demo_SetConsoleCursor(int x,int y)
{
	if (hStdout==NULL) hStdout=GetStdHandle(STD_OUTPUT_HANDLE);

	if (hStdout != INVALID_HANDLE_VALUE){
			GetConsoleScreenBufferInfo(hStdout, &csbiInfo);
			csbiInfo.dwCursorPosition.X=x;
			csbiInfo.dwCursorPosition.Y=y;
			SetConsoleCursorPosition(hStdout,csbiInfo.dwCursorPosition);
	}
}

void ARWin32Demo_AcquireConsole(int x,int y)
{
	vp_os_mutex_lock(&consoleMutex);
}
void ARWin32Demo_ReleaseConsole(int x,int y)
{
	vp_os_mutex_unlock(&consoleMutex);
}
