/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.ServiceCommunicatorListener;

public class ServiceCommunicator
extends BroadcastReceiver {
    private static final String logTag = "RDIS_LIB";
    private ServiceCommunicatorListener mListener = null;
    private Context mContext = null;
    private String mProtocol = null;

    public ServiceCommunicator(Context context, ServiceCommunicatorListener listener, String protocol) {
        Dbg.i(logTag, "ServiceCommunicator: ");
        this.mContext = context;
        this.mListener = listener;
        this.mProtocol = protocol;
        IntentFilter intentFilter = new IntentFilter("com.sony.rdis.intent.action.recv_geneal_purpose_communication");
        this.mContext.registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    public void sendData(int mobileId, String name, String value) {
        if (name == null || value == null) {
            Dbg.w(logTag, "sendData() name or value is illegal.");
            return;
        }
        Intent intent = new Intent("com.sony.rdis.intent.action.send_geneal_purpose_communication");
        intent.putExtra("protocol", this.mProtocol);
        intent.putExtra("clientId", mobileId);
        intent.putExtra("dataName", name);
        intent.putExtra("data", value);
        this.mContext.sendBroadcast(intent);
    }

    public void destroy() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
    }

    public void onReceive(Context context, Intent intent) {
        String protocol = intent.getStringExtra("protocol");
        int mobileId = intent.getIntExtra("clientId", -1);
        String name = intent.getStringExtra("dataName");
        String value = intent.getStringExtra("data");
        if (protocol.equals(this.mProtocol) && this.mListener != null) {
            this.mListener.recvData(mobileId, name, value);
        }
    }
}

