/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver;

import android.hardware.Sensor;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Process;
import android.view.MotionEvent;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.DaemonCommnunicatorListener;
import com.sony.rdis.receiver.HumanInterfaceDeviceInfomation;
import com.sony.rdis.receiver.RdisClient;
import com.sony.rdis.receiver.RdisRemoteController;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DaemonCommnunicator {
    private static final String logTag = "RDIS_LIB";
    private static final String DAEMON_SOCKET = "com.sony.rdis.daemon.receiver";
    private final int SYNC_BYTE = 71;
    private final int HEADER_SIZE = 12;
    private final int MAX_PACKET_SIZE = 0x100000;
    private final int MAX_PAYLOAD_SIZE = 1048564;
    private final int NUM_OF_RETRY = 0;
    private final int INTERVAL_OF_RETRY = 1000;
    private final int VERSION_MAJOR = 1;
    private final int VERSION_MINOR = 0;
    private final int VERSION_BUILD = 0;
    private DaemonCommnunicatorListener mListener = null;
    private LocalSocket mDaemonSocket = null;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private volatile boolean mRunning = true;
    private Thread mThread = null;
    private static final int SOCKETCMD_REPORT_CONNECTION = 0x800800;
    private static final int SOCKETCMD_REPORT_VERSION = 0x800A00;
    private static final int SOCKETCMD_REQUEST_VERSION = 8391169;
    private static final int SOCKETCMD_REPORT_MOBILE_CONNECTION = 8391170;
    private static final int SOCKETCMD_REPORT_MOBILE_DISCONNECTION = 8391171;
    private static final int SOCKETCMD_REQUEST_APPLICATION_ID = 8391172;
    private static final int SOCKETCMD_REPORT_APPLICATION_ID = 8391173;
    private static final int SOCKETCMD_REQUEST_SENSOR_START_FROM_LIB = 8391174;
    private static final int SOCKETCMD_REQUEST_SENSOR_STOP_FROM_LIB = 8391175;
    private static final int SOCKETCMD_REPORT_SENSOR_EVENT = 0x800A08;
    private static final int SOCKETCMD_REPORT_DEFAULT_SENSOR_CHANGED = 8391177;
    private static final int SOCKETCMD_REQUEST_SENSOR_START_FROM_HAL = 0x800A0A;
    private static final int SOCKETCMD_REQUEST_SENSOT_STOP_FROM_HAL = 8391179;
    private static final int SOCKETCMD_REQUEST_START_HAL_SENSOR = 8391180;
    private static final int SOCKETCMD_REQUEST_STOP_HAL_SENSOR = 8391181;
    private static final int SOCKETCMD_REQUEST_DELAY_OF_HAL_SENSOT = 8391182;
    private static final int SOCKETCMD_REPORT_REMOCON_CONNECT = 8391186;
    private static final int SOCKETCMD_REPORT_REMOCON_DISCONNECT = 8391187;
    private static final int SOCKETCMD_REPORT_TOUCH_EVENT = 8391188;
    private static final int SOCKETCMD_REPORT_SENSOR_DEFAULT_ID = 8391189;
    private static final int SOCKETCMD_REQUEST_VIBRATION = 8391190;

    public DaemonCommnunicator(DaemonCommnunicatorListener listener) {
        Dbg.i(logTag, "RdisDaemonCommnunicator: ");
        if (listener == null) {
            Dbg.e(logTag, "ERROR! listener is null!");
            return;
        }
        this.mListener = listener;
        this.mThread = new Thread(new Runnable(){

            public void run() {
                DaemonCommnunicator.this.threadLoop();
            }
        });
        this.mThread.start();
    }

    public boolean startSensor(int mobileId, int sensorType, int sensorRate) {
        Dbg.i(logTag, "startSensor" + mobileId + " - " + sensorType + " - " + sensorRate);
        return this.requestSensorStrat(mobileId, sensorType, sensorRate);
    }

    public void stopSensor(int mobileId, int sensorType) {
        Dbg.i(logTag, "stopSensor" + mobileId + " - " + sensorType);
        this.requestSensorStop(mobileId, sensorType);
    }

    public void vibrate(int mobileId, long milliseconds) {
        this.requestVibration(mobileId, (int)milliseconds);
    }

    public void stopThread() {
        Dbg.i(logTag, "stopThread: ");
        this.disconnect();
        this.mRunning = false;
    }

    private void threadLoop() {
        if (!this.connectWithRetry()) {
            if (this.mListener != null) {
                this.mListener.daemonConnectionFail();
            }
            Dbg.e(logTag, "connection error!");
            return;
        }
        byte[] header = new byte[12];
        while (this.mRunning) {
            try {
                int readSize;
                for (int readHeaderLength = 0; readHeaderLength < 12; readHeaderLength += readSize) {
                    readSize = this.mInputStream.read(header, readHeaderLength, 12 - readHeaderLength);
                    if (readSize >= 0) continue;
                    throw new IOException();
                }
                ByteBuffer buffer = ByteBuffer.wrap(header);
                buffer.order(ByteOrder.BIG_ENDIAN);
                if (buffer.get() != 71) {
                    throw new IOException();
                }
                buffer.position(4);
                int cmd = buffer.getInt();
                int length = buffer.getInt();
                byte[] payload = new byte[length];
                if (length > 0) {
                    int readSize2;
                    for (int readPayloadLength = 0; readPayloadLength < length; readPayloadLength += readSize2) {
                        readSize2 = this.mInputStream.read(payload, readPayloadLength, length - readPayloadLength);
                        if (readSize2 >= 0) continue;
                        throw new IOException();
                    }
                }
                this.parseRecvData(cmd, payload, length);
            }
            catch (IOException e) {
                Dbg.printStackTrace(e);
                this.disconnect();
                return;
            }
        }
        Dbg.i(logTag, "EXIT from THREAD LOOP.");
        this.disconnect();
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Dbg.e(logTag, "Interrupted while doing initial sleeping.", e);
        }
    }

    private boolean connectWithRetry() {
        boolean returnValue = false;
        for (int i = 0; i < 1 && !returnValue; ++i) {
            if (i != 0) {
                this.sleep(1000L);
            }
            returnValue = this.connect();
        }
        return returnValue;
    }

    private synchronized boolean connect() {
        Dbg.i(logTag, "########## connect");
        if (this.mDaemonSocket != null && this.mDaemonSocket.isConnected()) {
            return true;
        }
        try {
            this.mDaemonSocket = new LocalSocket();
            LocalSocketAddress daemonSocketAddress = new LocalSocketAddress(DAEMON_SOCKET, LocalSocketAddress.Namespace.RESERVED);
            this.mDaemonSocket.connect(daemonSocketAddress);
            this.mInputStream = this.mDaemonSocket.getInputStream();
            this.mOutputStream = this.mDaemonSocket.getOutputStream();
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            try {
                if (this.mDaemonSocket != null) {
                    this.mDaemonSocket.shutdownInput();
                    this.mDaemonSocket.shutdownOutput();
                    this.mDaemonSocket.close();
                    this.mDaemonSocket = null;
                }
            }
            catch (IOException e1) {
                Dbg.printStackTrace(e1);
            }
            Dbg.e(logTag, "DaemonSocket connection failed");
            return false;
        }
        this.reportConnection();
        return true;
    }

    private synchronized void disconnect() {
        Dbg.i(logTag, "########## disconnect");
        if (this.mDaemonSocket != null) {
            try {
                this.mDaemonSocket.shutdownInput();
                this.mDaemonSocket.shutdownOutput();
                this.mDaemonSocket.close();
            }
            catch (IOException e) {
                Dbg.printStackTrace(e);
            }
            this.mDaemonSocket = null;
        }
    }

    private void parseRecvData(int cmd, byte[] payload, int payloadLength) {
        switch (cmd) {
            case 0x800A00: {
                this.parseVersion(payload, payloadLength);
                break;
            }
            case 8391169: {
                this.reportVersion();
                break;
            }
            case 8391170: {
                this.parseMobleConnection(payload, payloadLength);
                break;
            }
            case 8391171: {
                this.parseMobleDisconnection(payload, payloadLength);
                break;
            }
            case 8391172: {
                this.reportApplicationId();
                break;
            }
            case 0x800A08: {
                this.parseSensorEvent(payload, payloadLength);
                break;
            }
            case 8391186: {
                this.parseRemoconConnect(payload, payloadLength);
                break;
            }
            case 8391188: {
                this.parseTouchEvent(payload, payloadLength);
                break;
            }
            case 8391189: {
                this.parseSensorDefaultId(payload, payloadLength);
                break;
            }
            default: {
                Dbg.e(logTag, "unknown cmd receved.   cmd: 0x" + Integer.toHexString(cmd));
            }
        }
    }

    private void parseSensorEvent(byte[] payload, int payloadLength) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int mobileId = buffer.getInt();
        int sensorType = buffer.getInt();
        float[] value = new float[]{buffer.getFloat(), buffer.getFloat(), buffer.getFloat()};
        int accuracy = buffer.getInt();
        int index = buffer.getInt();
        if (this.mListener != null) {
            this.mListener.sensorEvent(mobileId, sensorType, value, accuracy);
        }
    }

    private void parseMobleConnection(byte[] payload, int payloadLength) {
        int mobileId = -1;
        RdisClient rdisClinet = null;
        try {
            String json = new String(payload, 0, payloadLength, "UTF8");
            Dbg.d(logTag, "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] " + "json=" + json);
            JSONObject jobj = new JSONObject(json);
            mobileId = jobj.getInt("mobile_id");
            rdisClinet = new RdisClient(mobileId);
            int numOfSensors = jobj.getInt("num_of_sensors");
            JSONArray sensors = jobj.getJSONArray("sensors");
            if (numOfSensors != sensors.length()) {
                Dbg.e(logTag, "NumObSensors is wrong!");
            }
            for (int i = 0; i < sensors.length(); ++i) {
                float sensorResolution;
                float sensorPower;
                float sensorMaxRange;
                int sensorMinDelay;
                int sensorVersion;
                String sensorVendor;
                String sensorName;
                JSONObject sobj = sensors.getJSONObject(i);
                int sensorType = sobj.getInt("sensor_type");
                Sensor sensor = this.createSensorObject(sensorType, sensorName = sobj.getString("sensor_name"), sensorVendor = sobj.getString("sensor_vendor"), sensorVersion = sobj.getInt("sensor_version"), sensorMinDelay = sobj.getInt("sensor_min_delay"), sensorMaxRange = Float.parseFloat(sobj.getString("sensor_max_range")), sensorPower = Float.parseFloat(sobj.getString("sensor_power")), sensorResolution = Float.parseFloat(sobj.getString("sensor_resolution")));
                if (sensor == null) {
                    Dbg.e(logTag, "sensor object refrection error! ");
                    continue;
                }
                rdisClinet.addSensor(sensor);
            }
            String keyName = jobj.getString("key_device_name");
            HumanInterfaceDeviceInfomation hidInfo = new HumanInterfaceDeviceInfomation(1, keyName);
            rdisClinet.addHid(hidInfo);
            String touchName = jobj.getString("touch_device_name");
            hidInfo = new HumanInterfaceDeviceInfomation(2, touchName);
            rdisClinet.addHid(hidInfo);
            String mouseName = jobj.getString("mouse_device_name");
            hidInfo = new HumanInterfaceDeviceInfomation(3, mouseName);
            rdisClinet.addHid(hidInfo);
            boolean gpenable = jobj.getBoolean("enable_gp_com");
            String protocol = jobj.getString("protocol_name");
            rdisClinet.setGpCommunication(gpenable, protocol);
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            return;
        }
        catch (JSONException e) {
            Dbg.printStackTrace((Exception)((Object)e));
            return;
        }
        Dbg.i(logTag, "Connected!  mobileId=" + mobileId);
        if (this.mListener != null) {
            this.mListener.mobileConnection(mobileId, rdisClinet);
        }
    }

    private void parseMobleDisconnection(byte[] payload, int payloadLength) {
        int mobileId;
        try {
            String json = new String(payload, 0, payloadLength, "UTF8");
            JSONObject jobj = new JSONObject(json);
            mobileId = jobj.getInt("mobile_id");
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            return;
        }
        catch (JSONException e) {
            Dbg.printStackTrace((Exception)((Object)e));
            return;
        }
        Dbg.i(logTag, "disconnected!  mobileId=" + mobileId);
        if (this.mListener != null) {
            this.mListener.mobileDisconnection(mobileId);
        }
    }

    private void parseVersion(byte[] payload, int payloadLength) {
        int buildOfDaemon;
        int minorOfDaemon;
        int majorOfDaemon;
        try {
            String json = new String(payload, 0, payloadLength, "UTF8");
            JSONObject jobj = new JSONObject(json);
            majorOfDaemon = jobj.getInt("major");
            minorOfDaemon = jobj.getInt("minor");
            buildOfDaemon = jobj.getInt("build");
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            return;
        }
        catch (JSONException e) {
            Dbg.printStackTrace((Exception)((Object)e));
            return;
        }
        Dbg.i(logTag, "Daemon's VERSION = " + majorOfDaemon + "." + minorOfDaemon + "." + buildOfDaemon);
    }

    private void parseRemoconConnect(byte[] payload, int payloadLength) {
        int mobileId = 0;
        RdisRemoteController controller = null;
        try {
            String json = new String(payload, 0, payloadLength, "UTF8");
            JSONObject jobj = new JSONObject(json);
            mobileId = jobj.getInt("mobile_id");
            controller = new RdisRemoteController(mobileId);
            int numOfSensors = jobj.getInt("num_of_sensors");
            if (numOfSensors > 0) {
                JSONArray sensors = jobj.getJSONArray("sensors");
                if (numOfSensors != sensors.length()) {
                    Dbg.e(logTag, "mumObSensors is wrong!");
                }
                for (int i = 0; i < sensors.length(); ++i) {
                    float sensorResolution;
                    float sensorPower;
                    float sensorMaxRange;
                    int sensorMinDelay;
                    int sensorVersion;
                    String sensorVendor;
                    String sensorName;
                    JSONObject sobj = sensors.getJSONObject(i);
                    int sensorType = sobj.getInt("sensor_type");
                    Sensor sensor = this.createSensorObject(sensorType, sensorName = sobj.getString("sensor_name"), sensorVendor = sobj.getString("sensor_vendor"), sensorVersion = sobj.getInt("sensor_version"), sensorMinDelay = sobj.getInt("sensor_min_delay"), sensorMaxRange = Float.parseFloat(sobj.getString("sensor_max_range")), sensorPower = Float.parseFloat(sobj.getString("sensor_power")), sensorResolution = Float.parseFloat(sobj.getString("sensor_resolution")));
                    if (sensor == null) {
                        Dbg.e(logTag, "sensor object refrection error! ");
                        continue;
                    }
                    controller.addSensor(sensor);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            return;
        }
        catch (JSONException e) {
            Dbg.printStackTrace((Exception)((Object)e));
            return;
        }
        if (this.mListener != null) {
            this.mListener.remoconConnection(controller);
        }
        Dbg.i(logTag, "RemoteController connected! mobileId=" + mobileId);
    }

    private void parseSensorDefaultId(byte[] payload, int payloadLength) {
        int mobileId = 0;
        try {
            String json = new String(payload, 0, payloadLength, "UTF8");
            JSONObject jobj = new JSONObject(json);
            mobileId = jobj.getInt("mobile_id");
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            return;
        }
        catch (JSONException e) {
            Dbg.printStackTrace((Exception)((Object)e));
            return;
        }
        if (this.mListener != null) {
            this.mListener.defaultSensorChange(mobileId);
        }
        Dbg.i(logTag, "default sensor was changed!: mobileId:" + mobileId);
    }

    private void parseTouchEvent(byte[] payload, int payloadLength) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int mobileId = buffer.getInt();
        int numOfTouches = buffer.getInt();
        int[] pointerIds = new int[numOfTouches];
        int[] action = new int[numOfTouches];
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[numOfTouches];
        for (int i = 0; i < numOfTouches; ++i) {
            pointerIds[i] = i;
            action[i] = buffer.getInt();
            pointerCoords[i] = new MotionEvent.PointerCoords();
            pointerCoords[i].x = buffer.getFloat();
            pointerCoords[i].y = buffer.getFloat();
            pointerCoords[i].pressure = buffer.getFloat();
            pointerCoords[i].size = buffer.getFloat();
        }
        long timestamp = System.currentTimeMillis();
        MotionEvent event = MotionEvent.obtain((long)timestamp, (long)timestamp, (int)action[0], (int)numOfTouches, (int[])pointerIds, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0, (int)0, (int)0);
        if (this.mListener != null) {
            this.mListener.touchEvent(mobileId, event);
        }
    }

    private void reportConnection() {
        JSONObject jobj = new JSONObject();
        try {
            jobj.put("kind_of_client", (Object)"LIB");
        }
        catch (JSONException e) {
            Dbg.e(logTag, "ERROR :" + (Object)((Object)e));
            return;
        }
        this.write(0x800800, jobj.toString());
    }

    private void reportVersion() {
        JSONObject jobj = new JSONObject();
        try {
            jobj.put("major", 1);
            jobj.put("minor", 0);
            jobj.put("build", 0);
        }
        catch (JSONException e) {
            Dbg.e(logTag, "ERROR :" + (Object)((Object)e));
            return;
        }
        this.write(0x800A00, jobj.toString());
    }

    private void reportApplicationId() {
        int applicationId = Process.myPid();
        JSONObject jobj = new JSONObject();
        try {
            jobj.put("application_id", applicationId);
        }
        catch (JSONException e) {
            Dbg.e(logTag, "ERROR :" + (Object)((Object)e));
            return;
        }
        this.write(8391173, jobj.toString());
    }

    private boolean requestSensorStrat(int mobileId, int sensorType, int sensorRate) {
        JSONObject jobj = new JSONObject();
        try {
            jobj.put("mobile_id", mobileId);
            jobj.put("sensor_type", sensorType);
            jobj.put("sensor_rate", sensorRate);
            jobj.put("index", 0);
        }
        catch (JSONException e) {
            Dbg.e(logTag, "ERROR :" + (Object)((Object)e));
            return false;
        }
        return this.write(8391174, jobj.toString());
    }

    private void requestSensorStop(int mobileId, int sensorType) {
        JSONObject jobj = new JSONObject();
        try {
            jobj.put("mobile_id", mobileId);
            jobj.put("sensor_type", sensorType);
            jobj.put("index", 0);
        }
        catch (JSONException e) {
            Dbg.e(logTag, "ERROR :" + (Object)((Object)e));
            return;
        }
        this.write(8391175, jobj.toString());
    }

    private void requestVibration(int mobileId, int milliseconds) {
        JSONObject jobj = new JSONObject();
        try {
            jobj.put("mobile_id", mobileId);
            jobj.put("mode", (Object)"ONESHOT");
            jobj.put("milliseconds", milliseconds);
            jobj.put("pattern_len", 0);
            jobj.put("repeat", -1);
        }
        catch (JSONException e) {
            Dbg.e(logTag, "ERROR :" + (Object)((Object)e));
            return;
        }
        Dbg.i(logTag, "requestVibration()!");
        this.write(8391190, jobj.toString());
    }

    private boolean write(int cmd, String data) {
        if (this.mDaemonSocket == null) {
            Dbg.e(logTag, "socket error.");
            return false;
        }
        int len = 0;
        byte[] payload = null;
        if (data != null) {
            try {
                payload = data.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Dbg.printStackTrace(e);
                return false;
            }
            len = payload.length;
            if (len > 1048564) {
                Dbg.e(logTag, String.format("payload is too big! %d, cmd:0x%08x", len, cmd));
                return false;
            }
        }
        byte[] header = new byte[]{71, 0, 0, 0, (byte)((cmd & 0xFF000000) >> 24), (byte)((cmd & 0xFF0000) >> 16), (byte)((cmd & 0xFF00) >> 8), (byte)(cmd & 0xFF), (byte)((len & 0xFF000000) >> 24), (byte)((len & 0xFF0000) >> 16), (byte)((len & 0xFF00) >> 8), (byte)(len & 0xFF)};
        try {
            this.mOutputStream.write(header);
            if (len != 0 && payload != null) {
                this.mOutputStream.write(payload);
            }
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            return false;
        }
        return true;
    }

    private Sensor createSensorObject(int type, String name, String vendor, int version, int minDelay, float maxRange, float power, float resolution) {
        try {
            Constructor<?>[] cts = Class.forName("android.hardware.Sensor").getDeclaredConstructors();
            cts[0].setAccessible(true);
            Sensor sensor = (Sensor)cts[0].newInstance(new Object[0]);
            Field field = Class.forName("android.hardware.Sensor").getDeclaredField("mType");
            field.setAccessible(true);
            field.set(sensor, type);
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mName");
            field.setAccessible(true);
            field.set(sensor, name);
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mVendor");
            field.setAccessible(true);
            field.set(sensor, vendor);
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mVersion");
            field.setAccessible(true);
            field.set(sensor, version);
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mMaxRange");
            field.setAccessible(true);
            field.set(sensor, Float.valueOf(maxRange));
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mResolution");
            field.setAccessible(true);
            field.set(sensor, Float.valueOf(resolution));
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mPower");
            field.setAccessible(true);
            field.set(sensor, Float.valueOf(power));
            Dbg.v("DevInfo", "sensor (" + sensor.getName() + "," + sensor.getVendor() + "," + sensor.getVersion() + "," + sensor.getType() + "," + sensor.getMaximumRange() + "," + sensor.getResolution() + "," + sensor.getPower() + ") added");
            return sensor;
        }
        catch (SecurityException e) {
            Dbg.printStackTrace(e);
        }
        catch (ClassNotFoundException e) {
            Dbg.printStackTrace(e);
        }
        catch (IllegalArgumentException e) {
            Dbg.printStackTrace(e);
        }
        catch (InstantiationException e) {
            Dbg.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            Dbg.printStackTrace(e);
        }
        catch (InvocationTargetException e) {
            Dbg.printStackTrace(e);
        }
        catch (NoSuchFieldException e) {
            Dbg.printStackTrace(e);
        }
        return null;
    }
}

