/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.common;

import com.sony.rdis.common.Dbg;
import com.sony.rdis.common.SocketConnection;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UdpConnection
implements SocketConnection {
    private static final String logTag = "RDIS_COMMON";
    private final int MAX_UDP_DATA_LENGTH = 1024;
    private DatagramSocket mSocket = null;
    private InetAddress mInetAddress = null;
    private int mPortNumber = -1;

    public synchronized boolean connect(String destination, int number) {
        boolean ret = false;
        if (this.isConnected()) {
            this.disconnect();
        }
        try {
            String[] b = destination.split("\\.");
            byte[] ipAddress = new byte[]{(byte)Integer.parseInt(b[0]), (byte)Integer.parseInt(b[1]), (byte)Integer.parseInt(b[2]), (byte)Integer.parseInt(b[3])};
            this.mInetAddress = null;
            this.mInetAddress = InetAddress.getByAddress(ipAddress);
        }
        catch (UnknownHostException e) {
            Dbg.printStackTrace(e);
            return ret;
        }
        catch (NumberFormatException e) {
            Dbg.printStackTrace(e);
            return ret;
        }
        try {
            this.mPortNumber = number;
            Dbg.i(logTag, "UDP CONNECT TO :" + this.mInetAddress.getHostAddress() + ":" + this.mPortNumber);
            this.mSocket = new DatagramSocket();
            this.mSocket.setReuseAddress(true);
            ret = true;
        }
        catch (Exception e) {
            Dbg.printStackTrace(e);
        }
        return ret;
    }

    public synchronized void disconnect() {
        if (this.mSocket != null) {
            this.mSocket.close();
            this.mSocket = null;
        }
        this.mInetAddress = null;
    }

    public boolean isConnected() {
        return this.mSocket != null;
    }

    public byte[] read(int length) throws IOException {
        Dbg.e(logTag, "ERROR: Udp read method is not supported!");
        throw new IOException();
    }

    public synchronized boolean write(byte[] data) throws IOException {
        if (data.length <= 0 || data.length > 1024) {
            Dbg.e(logTag, "ERROR; data is empty or large. " + data.length);
            return false;
        }
        if (!this.isConnected()) {
            Dbg.e(logTag, "ERROR: udp socket disconnected.");
            return false;
        }
        DatagramPacket sendPacket = new DatagramPacket(data, data.length, this.mInetAddress, this.mPortNumber);
        try {
            this.mSocket.send(sendPacket);
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            throw new IOException();
        }
        return true;
    }
}

