/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver.utility;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.view.MotionEvent;
import com.sony.btv.remotesensor.RemoteSensor;
import com.sony.btv.remotesensor.RemoteSensorEvent;
import com.sony.btv.remotesensor.RemoteSensorEventListener;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.RdisClient;
import com.sony.rdis.receiver.RdisOnTouchListener;
import com.sony.rdis.receiver.RdisRemoteController;
import com.sony.rdis.receiver.utility.RdisUtilityEventListener;
import com.sony.rdis.receiver.utility.RdisUtilityGamePad;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class RdisUtilityGamePadInfo
implements SensorEventListener,
RdisOnTouchListener {
    private static final String logTag = "RDIS_UTIL";
    private int mMobileId = -1;
    public RdisClient mClient = null;
    public RdisRemoteController mRemoteController = null;
    public RdisUtilityGamePad mGamePad = null;
    public RdisUtilityEventListener mListener = null;
    public List<Integer> mRegisterdSensor = null;
    public List<Integer> mStartedSensor = null;
    public int mUserColor = 0;
    public boolean mGamePadInfoFlag = false;
    public String mNickname = null;
    public String mMacAddress = null;
    public boolean mRegisteredFlag = false;
    public final RemoteSensorEventListener mRemoteSensorEventListener = new RemoteSensorEventListener(){

        public void onSensorChanged(RemoteSensorEvent remoteSensorEvent) {
            try {
                Constructor<?>[] cts = Class.forName("android.hardware.SensorEvent").getDeclaredConstructors();
                cts[0].setAccessible(true);
                SensorEvent androidSensorEvent = (SensorEvent)cts[0].newInstance(3);
                androidSensorEvent.values[0] = remoteSensorEvent.values[0];
                androidSensorEvent.values[1] = remoteSensorEvent.values[1];
                androidSensorEvent.values[2] = remoteSensorEvent.values[2];
                androidSensorEvent.sensor = RdisUtilityGamePadInfo.this.remoteSensorToAndroidSensor(remoteSensorEvent.sensor);
                androidSensorEvent.accuracy = remoteSensorEvent.accuracy;
                androidSensorEvent.timestamp = remoteSensorEvent.timestamp;
                RdisUtilityGamePadInfo.this.onSensorChanged(androidSensorEvent);
            }
            catch (SecurityException e1) {
                Dbg.printStackTrace((Exception)e1);
            }
            catch (ClassNotFoundException e1) {
                Dbg.printStackTrace((Exception)e1);
            }
            catch (IllegalArgumentException e) {
                Dbg.printStackTrace((Exception)e);
            }
            catch (InstantiationException e) {
                Dbg.printStackTrace((Exception)e);
            }
            catch (IllegalAccessException e) {
                Dbg.printStackTrace((Exception)e);
            }
            catch (InvocationTargetException e) {
                Dbg.printStackTrace((Exception)e);
            }
        }

        public void onAccuracyChanged(RemoteSensor remoteSensor, int accuracy) {
            RdisUtilityGamePadInfo.this.onAccuracyChanged(RdisUtilityGamePadInfo.this.remoteSensorToAndroidSensor(remoteSensor), accuracy);
        }
    };

    public RdisUtilityGamePadInfo(int mobileId) {
        Dbg.i((String)logTag, (String)"RdisUtilityGamePadInfo: ");
        this.mMobileId = mobileId;
        this.mRegisterdSensor = new ArrayList<Integer>();
        this.mStartedSensor = new ArrayList<Integer>();
    }

    public int getMobileId() {
        return this.mMobileId;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        if (this.mListener != null) {
            this.mListener.onAccuracyChanged(sensor, accuracy);
        }
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.mListener != null) {
            this.mListener.onSensorChanged(event);
        }
    }

    public void onTouchEvent(MotionEvent event) {
        if (this.mListener != null) {
            this.mListener.onTouchEvent(event);
        }
    }

    private Sensor remoteSensorToAndroidSensor(RemoteSensor remoteSensor) {
        try {
            Constructor<?>[] cts = Class.forName("android.hardware.Sensor").getDeclaredConstructors();
            cts[0].setAccessible(true);
            Sensor androidSensor = (Sensor)cts[0].newInstance(new Object[0]);
            Field field = Class.forName("android.hardware.Sensor").getDeclaredField("mType");
            field.setAccessible(true);
            field.set(androidSensor, remoteSensor.getType());
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mName");
            field.setAccessible(true);
            field.set(androidSensor, remoteSensor.getName());
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mVendor");
            field.setAccessible(true);
            field.set(androidSensor, remoteSensor.getVendor());
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mVersion");
            field.setAccessible(true);
            field.set(androidSensor, remoteSensor.getVersion());
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mMaxRange");
            field.setAccessible(true);
            field.set(androidSensor, Float.valueOf(remoteSensor.getMaximumRange()));
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mResolution");
            field.setAccessible(true);
            field.set(androidSensor, Float.valueOf(remoteSensor.getResolution()));
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mPower");
            field.setAccessible(true);
            field.set(androidSensor, Float.valueOf(remoteSensor.getPower()));
            field = Class.forName("android.hardware.Sensor").getDeclaredField("mMinDelay");
            field.setAccessible(true);
            field.set(androidSensor, remoteSensor.getMinDelay());
            return androidSensor;
        }
        catch (SecurityException e) {
            Dbg.printStackTrace((Exception)e);
        }
        catch (ClassNotFoundException e) {
            Dbg.printStackTrace((Exception)e);
        }
        catch (NoSuchFieldException e) {
            Dbg.printStackTrace((Exception)e);
        }
        catch (IllegalArgumentException e) {
            Dbg.printStackTrace((Exception)e);
        }
        catch (IllegalAccessException e) {
            Dbg.printStackTrace((Exception)e);
        }
        catch (InstantiationException e) {
            Dbg.printStackTrace((Exception)e);
        }
        catch (InvocationTargetException e) {
            Dbg.printStackTrace((Exception)e);
        }
        return null;
    }
}

