/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver.utility;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.sony.btv.remotesensor.RemoteSensor;
import com.sony.btv.remotesensor.RemoteSensorManager;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.RdisClient;
import com.sony.rdis.receiver.RdisClientListener;
import com.sony.rdis.receiver.RdisDefaultSensorListener;
import com.sony.rdis.receiver.RdisGeneralCommunicationListener;
import com.sony.rdis.receiver.RdisManager;
import com.sony.rdis.receiver.RdisOnTouchListener;
import com.sony.rdis.receiver.RdisRemoteController;
import com.sony.rdis.receiver.RdisRemoteControllerListener;
import com.sony.rdis.receiver.utility.RdisUtilityConnectionListener;
import com.sony.rdis.receiver.utility.RdisUtilityEventListener;
import com.sony.rdis.receiver.utility.RdisUtilityGamePad;
import com.sony.rdis.receiver.utility.RdisUtilityGamePadInfo;
import com.sony.rdis.receiver.utility.RdisUtilityKeyConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdisUtility {
    private static final boolean DEBUG_HID = false;
    private static final String logTag = "RDIS_UTIL";
    private final int DEFAULT_GAME_PAD_ID = -1;
    private final int DEFAULT_SENSOR_RATE = 2;
    private RdisUtilityConnectionListener mListener = null;
    private Activity mActivity = null;
    private RemoteSensorManager mSensorManager;
    private RdisUtilityGamePadInfo mRemoconGamePadInfo = null;
    private List<RdisUtilityGamePadInfo> mGamePadInfoList = null;
    private RdisManager mRdisManager = null;
    private RdisClientListener mRdisClientListener = null;
    private int mDefaultSensorMobileId = -100;
    private RdisUtilityGamePadInfo mDefaultSensorGamePadInfo = null;
    private RdisDefaultSensorListener mRdisDefaultSensorListener = null;
    private RdisRemoteControllerListener mRdisRemoteControllerListener = null;
    private RdisGeneralCommunicationListener mRdisGeneralCommunicationListener = null;
    private String mKeyConfiguration = null;
    private boolean mActivityIsResumed = false;
    private static final String mRemoteControlString = "Remote Control";

    public RdisUtility(Activity activity, RdisUtilityConnectionListener listener, RdisUtilityKeyConfiguration keyConfig) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.i((String)logTag, (String)"RdisUtility: initialzie. __2011_09_13_A__");
        if (activity == null) {
            Dbg.e((String)logTag, (String)"activity is null!");
            throw new NullPointerException();
        }
        if (listener == null) {
            Dbg.e((String)logTag, (String)"listener is null!");
            throw new NullPointerException();
        }
        this.mActivity = activity;
        this.mListener = listener;
        this.mRdisClientListener = new RdisClientListener(){

            public void onStatusChanged(int status, List<RdisClient> clientList) {
                RdisUtility.this.rdisLibStatusChanged(status, clientList);
            }
        };
        this.mRdisDefaultSensorListener = new RdisDefaultSensorListener(){

            public void onDefaultSensorChanged(int mobileId) {
                RdisUtility.this.changeDefaultSensorMobile(mobileId);
            }
        };
        this.mRdisRemoteControllerListener = new RdisRemoteControllerListener(){

            public void onConnected(RdisRemoteController controller) {
                RdisUtility.this.initRemoconGamePad(controller);
            }
        };
        this.mGamePadInfoList = new ArrayList<RdisUtilityGamePadInfo>();
        this.mSensorManager = RemoteSensorManager.getInstance((Activity)activity);
        this.mRdisManager = RdisManager.getRdisManager((Activity)activity);
        this.mRdisGeneralCommunicationListener = new RdisGeneralCommunicationListener(){

            public void onRecvData(int mobileId, String name, String value) {
                RdisUtility.this.recvedGeneralCommunicationData(mobileId, name, value);
            }
        };
        this.mRdisManager.initGeneralCommunication(activity, "com.sony.rdis.gamepad.GamePad", this.mRdisGeneralCommunicationListener);
        if (keyConfig != null) {
            this.createKeyConfigMessage(keyConfig);
        }
        new Handler(){

            public void handleMessage(Message msg) {
                RdisUtility.this.initPostProcess();
            }
        }.sendEmptyMessage(0);
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    private void initPostProcess() {
        Dbg.i((String)logTag, (String)"initPostProcess()");
        this.mRdisManager.registerListener(this.mRdisClientListener);
        this.mRdisManager.registerDefaultSensorListener(this.mRdisDefaultSensorListener);
        this.mRdisManager.registerRemoteControllerListener(this.mRdisRemoteControllerListener);
    }

    private void initRemoconGamePad(RdisRemoteController remocon) {
        Dbg.i((String)logTag, (String)"initRemoconGamePad()");
        int mobileId = remocon.getMobileId();
        int[] sensors = this.getSensorType(remocon);
        this.mRemoconGamePadInfo = new RdisUtilityGamePadInfo(mobileId);
        this.mRemoconGamePadInfo.mMacAddress = mRemoteControlString;
        this.mRemoconGamePadInfo.mNickname = mRemoteControlString;
        this.mRemoconGamePadInfo.mGamePadInfoFlag = true;
        this.mRemoconGamePadInfo.mGamePad = new RdisUtilityGamePad(true, mobileId, sensors, this.mRemoconGamePadInfo);
        this.mRemoconGamePadInfo.mRemoteController = remocon;
        if (mobileId == this.mDefaultSensorMobileId) {
            this.changeDefaultSensorMobile(mobileId);
        }
        if (this.mListener != null) {
            this.mListener.onConnected(this.mRemoconGamePadInfo.mGamePad);
        }
    }

    public void resume() {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.i((String)logTag, (String)"RdisUtility::resume: ");
        this.mActivityIsResumed = true;
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (!gamePadInfo.mGamePadInfoFlag) continue;
            this.startSensor(gamePadInfo);
            this.settingGamePad(gamePadInfo);
            this.startHIDEvent(gamePadInfo);
        }
        if (this.mRemoconGamePadInfo != null) {
            this.startSensor(this.mRemoconGamePadInfo);
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    public void pause() {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.i((String)logTag, (String)"RdisUtility::pause: ");
        this.mActivityIsResumed = false;
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (!gamePadInfo.mGamePadInfoFlag) continue;
            this.stopSensor(gamePadInfo);
            this.unsettingGamePad(gamePadInfo);
            this.stopHIDEvent(gamePadInfo);
        }
        if (this.mRemoconGamePadInfo != null) {
            this.stopSensor(this.mRemoconGamePadInfo);
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    public void destroy() {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.i((String)logTag, (String)"RdisUtility::destroy: ");
        this.mRdisManager.unregisterListener(this.mRdisClientListener);
        this.mRdisManager.unregisterDefaultSensorListener();
        this.mRdisManager.unregisterRemoteControllerListener();
        this.mRdisManager.destroyGeneralCommunication();
        this.mRdisManager.destroy();
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    public boolean keyDownEventDelivery(int keyCode, KeyEvent event) {
        if (event == null) {
            Dbg.e((String)logTag, (String)"event is null!");
            return false;
        }
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (event.getDeviceId() != gamePadInfo.mClient.getKeyDeviceId()) continue;
            if (gamePadInfo.mListener != null) {
                return gamePadInfo.mListener.onKeyDown(keyCode, event);
            }
            Dbg.i((String)logTag, (String)"Not supported in this version!");
            return false;
        }
        if (this.mRemoconGamePadInfo != null && this.mRemoconGamePadInfo.mListener != null) {
            return this.mRemoconGamePadInfo.mListener.onKeyDown(keyCode, event);
        }
        return false;
    }

    public boolean keyUpEventDelivery(int keyCode, KeyEvent event) {
        if (event == null) {
            Dbg.e((String)logTag, (String)"event is null!");
            return false;
        }
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (event.getDeviceId() != gamePadInfo.mClient.getKeyDeviceId()) continue;
            if (gamePadInfo.mListener != null) {
                return gamePadInfo.mListener.onKeyUp(keyCode, event);
            }
            Dbg.i((String)logTag, (String)"EventListener is not registered.");
            return false;
        }
        if (this.mRemoconGamePadInfo != null && this.mRemoconGamePadInfo.mListener != null) {
            return this.mRemoconGamePadInfo.mListener.onKeyUp(keyCode, event);
        }
        return false;
    }

    public boolean touchEventDelivery(MotionEvent event) {
        if (event == null) {
            Dbg.e((String)logTag, (String)"event is null!");
            return false;
        }
        for (RdisUtilityGamePadInfo GamePadInfo : this.mGamePadInfoList) {
            int devId = event.getDeviceId();
            if (devId != GamePadInfo.mClient.getMouseDeviceId() && devId != GamePadInfo.mClient.getTouchPanelDeviceId()) continue;
            if (GamePadInfo.mListener != null) {
                return GamePadInfo.mListener.onTouchEvent(event);
            }
            Dbg.i((String)logTag, (String)"EventListener is not registered.");
            return false;
        }
        if (this.mRemoconGamePadInfo != null && this.mRemoconGamePadInfo.mListener != null) {
            return this.mRemoconGamePadInfo.mListener.onTouchEvent(event);
        }
        return false;
    }

    public boolean registerGamePad(RdisUtilityGamePad gamePad, RdisUtilityEventListener listener, int[] sensorType, int userColor) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        if (gamePad == null) {
            Dbg.e((String)logTag, (String)"gamePad is null!");
            return false;
        }
        if (sensorType != null && sensorType.length > 0) {
            Dbg.i((String)logTag, (String)("sensorType.length= " + sensorType.length));
            Dbg.i((String)logTag, (String)("sensorType[0] = " + sensorType[0]));
            if (!this.isSensorTypeValid(sensorType, gamePad.getSensorType())) {
                Dbg.e((String)logTag, (String)"sensorType includes invalid value");
                return false;
            }
        }
        Dbg.i((String)logTag, (String)"registerGamePad: ");
        if (gamePad.isDefaultGamePad()) {
            return this.registerGamePadInfo(this.mRemoconGamePadInfo, listener, sensorType, userColor);
        }
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (gamePadInfo.getMobileId() != gamePad.getDeviceId()) continue;
            return this.registerGamePadInfo(gamePadInfo, listener, sensorType, userColor);
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
        return false;
    }

    public void unregisterGamePad(RdisUtilityGamePad gamePad) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.i((String)logTag, (String)"unregisterGamePad: ");
        if (gamePad == null) {
            Dbg.e((String)logTag, (String)"gamePad is null");
            return;
        }
        if (gamePad.isDefaultGamePad()) {
            this.unregisterGamePadInfo(this.mRemoconGamePadInfo);
        } else {
            for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
                if (gamePadInfo.getMobileId() != gamePad.getDeviceId()) continue;
                this.unregisterGamePadInfo(gamePadInfo);
                break;
            }
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    private boolean registerGamePadInfo(RdisUtilityGamePadInfo gamePadInfo, RdisUtilityEventListener listener, int[] sensorType, int userColor) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.d((String)logTag, (String)("gamePadInfo.mListener=" + gamePadInfo.mListener));
        if (gamePadInfo.mListener == null) {
            gamePadInfo.mListener = listener;
            if (sensorType != null) {
                for (int i = 0; i < sensorType.length; ++i) {
                    Dbg.d((String)logTag, (String)("gamePadInfo.mRegisterdSensor.add() sensorType[" + i + "] = " + sensorType[i]));
                    gamePadInfo.mRegisterdSensor.add(sensorType[i]);
                }
            }
            if (userColor != 0) {
                gamePadInfo.mUserColor = userColor;
            }
            if (this.mActivityIsResumed) {
                this.startSensor(gamePadInfo);
                this.settingGamePad(gamePadInfo);
                this.startHIDEvent(gamePadInfo);
            }
            gamePadInfo.mRegisteredFlag = true;
            Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
            return true;
        }
        Dbg.e((String)logTag, (String)"EventListener was already registered, so this request is fail.");
        return false;
    }

    private void unregisterGamePadInfo(RdisUtilityGamePadInfo GamePadInfo) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        if (this.mActivityIsResumed) {
            this.stopSensor(GamePadInfo);
            this.unsettingGamePad(GamePadInfo);
            this.stopHIDEvent(GamePadInfo);
        }
        Iterator<Integer> it = GamePadInfo.mRegisterdSensor.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        GamePadInfo.mListener = null;
        GamePadInfo.mRegisteredFlag = false;
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSensor(RdisUtilityGamePadInfo GamePadInfo) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        RdisUtilityGamePadInfo rdisUtilityGamePadInfo = GamePadInfo;
        synchronized (rdisUtilityGamePadInfo) {
            Iterator<Integer> it = GamePadInfo.mRegisterdSensor.iterator();
            while (it.hasNext()) {
                Integer sensorType = it.next();
                List<Sensor> sensorlist = this.getSensorList(GamePadInfo, sensorType);
                if (sensorlist == null) {
                    Dbg.e((String)logTag, (String)"startSensor(): invalid GamePadInfo!");
                    return;
                }
                if (sensorlist.size() != 0) {
                    Sensor sensor = sensorlist.get(0);
                    RdisManager.sensor.registerListener((SensorEventListener)GamePadInfo, sensor, 2);
                }
                GamePadInfo.mStartedSensor.add(sensorType);
                it.remove();
                if (GamePadInfo != this.mDefaultSensorGamePadInfo || Build.DEVICE.equalsIgnoreCase("asura") || Build.DEVICE.equalsIgnoreCase("eagle")) continue;
                List sensorlistFW = this.mSensorManager.getSensorList(-1);
                if (sensorlist == null) {
                    Dbg.e((String)logTag, (String)"stopSensor(): invalid GamePadInfo!");
                    return;
                }
                RemoteSensor sensorFW = (RemoteSensor)sensorlistFW.get(0);
                this.mSensorManager.registerListener(GamePadInfo.mRemoteSensorEventListener, sensorFW, 2);
            }
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSensor(RdisUtilityGamePadInfo GamePadInfo) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        RdisUtilityGamePadInfo rdisUtilityGamePadInfo = GamePadInfo;
        synchronized (rdisUtilityGamePadInfo) {
            Iterator<Integer> it = GamePadInfo.mStartedSensor.iterator();
            while (it.hasNext()) {
                Integer sensorType = it.next();
                List<Sensor> sensorlist = this.getSensorList(GamePadInfo, sensorType);
                if (sensorlist == null) {
                    Dbg.e((String)logTag, (String)"stopSensor(): invalid GamePadInfo!");
                    return;
                }
                if (sensorlist.size() != 0) {
                    Sensor sensor = sensorlist.get(0);
                    RdisManager.sensor.unregisterListener((SensorEventListener)GamePadInfo, sensor);
                }
                if (GamePadInfo == this.mDefaultSensorGamePadInfo) {
                    this.mSensorManager.unregisterListener(GamePadInfo.mRemoteSensorEventListener, this.mSensorManager.getDefaultSensor(sensorType.intValue()));
                }
                GamePadInfo.mRegisterdSensor.add(sensorType);
                it.remove();
            }
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    private void rdisLibStatusChanged(int status, List<RdisClient> clientList) {
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start"));
        Dbg.i((String)logTag, (String)("rdisLibStatusChanged: status=" + status + " (ADDED= " + 1 + ")"));
        switch (status) {
            case 1: {
                for (RdisClient client : clientList) {
                    int deviceId = client.getMobileId();
                    RdisUtilityGamePadInfo GamePadInfo = new RdisUtilityGamePadInfo(deviceId);
                    RdisUtilityGamePad GamePad = new RdisUtilityGamePad(false, deviceId, this.getRdisSensorType(client), GamePadInfo);
                    GamePadInfo.mClient = client;
                    GamePadInfo.mGamePad = GamePad;
                    GamePadInfo.mGamePadInfoFlag = false;
                    this.mGamePadInfoList.add(GamePadInfo);
                    this.mRdisManager.sendGeneralCommunication(GamePadInfo.getMobileId(), "REQUEST_NICKNAME", "");
                    this.mRdisManager.sendGeneralCommunication(GamePadInfo.getMobileId(), "REQUEST_MAC_ADDRESS", "");
                    if (deviceId != this.mDefaultSensorMobileId) continue;
                    this.changeDefaultSensorMobile(deviceId);
                }
                break;
            }
            case -1: 
            case 2: {
                for (RdisClient client : clientList) {
                    int deviceId = client.getMobileId();
                    Iterator<RdisUtilityGamePadInfo> it = this.mGamePadInfoList.iterator();
                    while (it.hasNext()) {
                        RdisUtilityGamePadInfo GamePadInfo = it.next();
                        if (GamePadInfo.getMobileId() != deviceId) continue;
                        RdisUtilityGamePad GamePad = GamePadInfo.mGamePad;
                        if (this.mListener != null) {
                            this.mListener.onDisconnected(GamePad);
                        }
                        this.unregisterGamePadInfo(GamePadInfo);
                        it.remove();
                    }
                }
                break;
            }
            default: {
                Dbg.e((String)logTag, (String)"unknown status!");
            }
        }
        Dbg.d((String)logTag, (String)("[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end"));
    }

    private List<Sensor> getSensorList(RdisUtilityGamePadInfo gamePadInfo, int sensorType) {
        List sensorlist = null;
        if (gamePadInfo.mClient != null) {
            sensorlist = gamePadInfo.mClient.getSensorList(sensorType);
        } else if (gamePadInfo.mRemoteController != null) {
            sensorlist = gamePadInfo.mRemoteController.getSensorList(sensorType);
        }
        return sensorlist;
    }

    private int[] getSensorType(RdisRemoteController remocon) {
        if (!Build.DEVICE.equalsIgnoreCase("asura") && !Build.DEVICE.equalsIgnoreCase("eagle")) {
            List ssfSensorList = this.mSensorManager.getSensorList(-1);
            ArrayList<Sensor> androidSensorList = new ArrayList<Sensor>();
            for (RemoteSensor remoteSensor : ssfSensorList) {
                try {
                    Constructor<?>[] cts = Class.forName("android.hardware.Sensor").getDeclaredConstructors();
                    cts[0].setAccessible(true);
                    Sensor androidSensor = (Sensor)cts[0].newInstance(new Object[0]);
                    Field field = Class.forName("android.hardware.Sensor").getDeclaredField("mType");
                    field.setAccessible(true);
                    field.set(androidSensor, remoteSensor.getType());
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mName");
                    field.setAccessible(true);
                    field.set(androidSensor, remoteSensor.getName());
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mVendor");
                    field.setAccessible(true);
                    field.set(androidSensor, remoteSensor.getVendor());
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mVersion");
                    field.setAccessible(true);
                    field.set(androidSensor, remoteSensor.getVersion());
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mMaxRange");
                    field.setAccessible(true);
                    field.set(androidSensor, Float.valueOf(remoteSensor.getMaximumRange()));
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mResolution");
                    field.setAccessible(true);
                    field.set(androidSensor, Float.valueOf(remoteSensor.getResolution()));
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mPower");
                    field.setAccessible(true);
                    field.set(androidSensor, Float.valueOf(remoteSensor.getPower()));
                    field = Class.forName("android.hardware.Sensor").getDeclaredField("mMinDelay");
                    field.setAccessible(true);
                    field.set(androidSensor, remoteSensor.getMinDelay());
                    androidSensorList.add(androidSensor);
                }
                catch (SecurityException e) {
                    Dbg.printStackTrace((Exception)e);
                }
                catch (ClassNotFoundException e) {
                    Dbg.printStackTrace((Exception)e);
                }
                catch (IllegalArgumentException e) {
                    Dbg.printStackTrace((Exception)e);
                }
                catch (InstantiationException e) {
                    Dbg.printStackTrace((Exception)e);
                }
                catch (IllegalAccessException e) {
                    Dbg.printStackTrace((Exception)e);
                }
                catch (InvocationTargetException e) {
                    Dbg.printStackTrace((Exception)e);
                }
                catch (NoSuchFieldException e) {
                    Dbg.printStackTrace((Exception)e);
                }
            }
            return this.sensorListToSensorTypes(androidSensorList);
        }
        return new int[0];
    }

    private int[] getRdisSensorType(RdisClient client) {
        return this.sensorListToSensorTypes(client.getSensorList(-1));
    }

    private int[] sensorListToSensorTypes(List<Sensor> sensorList) {
        int[] sensorarray = new int[sensorList.size()];
        int i = 0;
        for (Sensor sensor : sensorList) {
            sensorarray[i++] = sensor.getType();
        }
        return sensorarray;
    }

    private void recvedGeneralCommunicationData(int mobileId, String name, String value) {
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (gamePadInfo.getMobileId() != mobileId) continue;
            if (!gamePadInfo.mGamePadInfoFlag) {
                JSONObject jobj;
                if (name.equals("SEND_NICKNAME")) {
                    try {
                        jobj = new JSONObject(value);
                        gamePadInfo.mNickname = jobj.getString("NICKNAME");
                    }
                    catch (JSONException e) {
                        Dbg.e((String)logTag, (String)("ERROR nickname : " + (Object)((Object)e)));
                    }
                } else if (name.equals("SEND_MAC_ADDRESS")) {
                    try {
                        jobj = new JSONObject(value);
                        gamePadInfo.mMacAddress = jobj.getString("MAC_ADDRESS");
                    }
                    catch (JSONException e) {
                        Dbg.e((String)logTag, (String)("ERROR nickname : " + (Object)((Object)e)));
                    }
                } else {
                    Dbg.e((String)logTag, (String)("ERROR: RECV UNKNOWN DATA: " + name));
                }
                if (gamePadInfo.mMacAddress == null || gamePadInfo.mNickname == null) continue;
                gamePadInfo.mGamePadInfoFlag = true;
                if (this.mListener == null) continue;
                this.mListener.onConnected(gamePadInfo.mGamePad);
                continue;
            }
            Dbg.e((String)logTag, (String)("ERROR: RECV DATA in UNKNOWN TIMING: " + name));
        }
    }

    private void createKeyConfigMessage(RdisUtilityKeyConfiguration keyConfig) {
        JSONObject jobj = new JSONObject();
        try {
            if (keyConfig.useAnalogStick) {
                jobj.put("DIRECTIONAL", (Object)"ANALOG");
            } else {
                jobj.put("DIRECTIONAL", (Object)"DIGITAL");
            }
            jobj.put("DIRECTIONAL_KEY_UP", keyConfig.keyUp);
            jobj.put("DIRECTIONAL_KEY_DOWN", keyConfig.keyDown);
            jobj.put("DIRECTIONAL_KEY_LEFT", keyConfig.keyLeft);
            jobj.put("DIRECTIONAL_KEY_RIGHT", keyConfig.keyRight);
            jobj.put("KEY_A", keyConfig.keyA);
            jobj.put("KEY_B", keyConfig.keyB);
            jobj.put("KEY_C", keyConfig.keyC);
            jobj.put("KEY_D", keyConfig.keyD);
        }
        catch (JSONException e) {
            Dbg.e((String)logTag, (String)("ERROR :" + (Object)((Object)e)));
            return;
        }
        this.mKeyConfiguration = jobj.toString();
        jobj = null;
    }

    private void settingGamePad(RdisUtilityGamePadInfo GamePadInfo) {
        if (this.mKeyConfiguration != null) {
            this.mRdisManager.sendGeneralCommunication(GamePadInfo.getMobileId(), "SET_KEY_CONFIG", this.mKeyConfiguration);
        }
        if (GamePadInfo.mUserColor != 0) {
            JSONObject jobj = new JSONObject();
            try {
                jobj.put("USER_COLOR", (Object)("0x" + Integer.toHexString(GamePadInfo.mUserColor)));
            }
            catch (JSONException e) {
                Dbg.e((String)logTag, (String)("ERROR :" + (Object)((Object)e)));
                return;
            }
            this.mRdisManager.sendGeneralCommunication(GamePadInfo.getMobileId(), "SET_USER_COLOR", jobj.toString());
        }
    }

    private void unsettingGamePad(RdisUtilityGamePadInfo GamePadInfo) {
        if (this.mKeyConfiguration != null) {
            this.mRdisManager.sendGeneralCommunication(GamePadInfo.getMobileId(), "UNSET_KEY_CONFIG", "");
        }
        if (GamePadInfo.mUserColor != 0) {
            this.mRdisManager.sendGeneralCommunication(GamePadInfo.getMobileId(), "UNSET_USER_COLOR", "");
        }
    }

    private void changeDefaultSensorMobile(int newMobileId) {
        this.mDefaultSensorMobileId = newMobileId;
        for (RdisUtilityGamePadInfo gamePadInfo : this.mGamePadInfoList) {
            if (gamePadInfo.getMobileId() != newMobileId) continue;
            this.changeDefaultSensorGamePadInfo(gamePadInfo);
            return;
        }
        if (this.mRemoconGamePadInfo != null && this.mRemoconGamePadInfo.getMobileId() == newMobileId) {
            this.changeDefaultSensorGamePadInfo(this.mRemoconGamePadInfo);
            return;
        }
        Dbg.i((String)logTag, (String)("changeDefaultSensorMobile(): mobileId:" + newMobileId + " has not been connected yet"));
    }

    private void changeDefaultSensorGamePadInfo(RdisUtilityGamePadInfo newInfo) {
        RdisUtilityGamePadInfo oldPad = this.mDefaultSensorGamePadInfo;
        this.mDefaultSensorGamePadInfo = newInfo;
        this.updateDefaultSensors(oldPad);
        Dbg.v((String)logTag, (String)("changeDefaultSensorMobile(): newMobileId:" + newInfo.getMobileId()));
    }

    private void updateDefaultSensors(RdisUtilityGamePadInfo oldPad) {
        if (oldPad != null) {
            for (Integer o : oldPad.mStartedSensor) {
                this.mSensorManager.unregisterListener(oldPad.mRemoteSensorEventListener, this.mSensorManager.getDefaultSensor(o.intValue()));
            }
        }
        for (Integer n : this.mDefaultSensorGamePadInfo.mStartedSensor) {
            this.mSensorManager.registerListener(this.mDefaultSensorGamePadInfo.mRemoteSensorEventListener, this.mSensorManager.getDefaultSensor(n.intValue()), 2);
        }
    }

    private void startHIDEvent(RdisUtilityGamePadInfo info) {
        RdisManager.mRdisHidManager.registerOnTouchListener(info.getMobileId(), (RdisOnTouchListener)info);
    }

    private void stopHIDEvent(RdisUtilityGamePadInfo info) {
        RdisManager.mRdisHidManager.unregisterOnTouchListener(info.getMobileId(), (RdisOnTouchListener)info);
    }

    private boolean isSensorTypeValid(int[] user, int[] orig) {
        for (int u : user) {
            boolean found = false;
            for (int o : orig) {
                if (u != o) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

