/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.RdisClient;
import com.sony.rdis.receiver.RdisRemoteController;
import com.sony.rdis.receiver.RdisSensorManagerListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdisSensorManager {
    private static final boolean DEBUG_SENSOR = true;
    protected static final String LOG_TAG = "RdisSensorManager";
    protected static final String logTag = "RdisSensorManager";
    private static final int SENSOR_DISABLE = -1;
    private Context mContext;
    private static ArrayList<RdisClient> mClientList;
    private static ArrayList<RdisRemoteController> mRemoconList;
    private static ArrayList<ListenerDelegate> sListeners;
    private int listenerId = 0;
    private RdisSensorManagerListener mListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void recvSensorEvent(int mobileId, int sensorType, float[] values, int accuracy) {
        long[] timestamp = new long[]{System.currentTimeMillis()};
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            List<Sensor> sensorList;
            if (sListeners.isEmpty()) {
                return;
            }
            Sensor sensorObject = null;
            for (RdisClient rdisClient : mClientList) {
                if (rdisClient.getMobileId() != mobileId) continue;
                sensorList = rdisClient.getSensorList(sensorType);
                if (sensorList.isEmpty()) break;
                sensorObject = sensorList.get(0);
                break;
            }
            if (sensorObject == null) {
                for (RdisRemoteController rdisRemoteController : mRemoconList) {
                    if (rdisRemoteController.getMobileId() != mobileId) continue;
                    sensorList = rdisRemoteController.getSensorList(sensorType);
                    if (sensorList.isEmpty()) break;
                    sensorObject = sensorList.get(0);
                    break;
                }
            }
            if (sensorObject != null) {
                void var9_14;
                int size = sListeners.size();
                boolean bl = false;
                while (var9_14 < size) {
                    ListenerDelegate listener = sListeners.get((int)var9_14);
                    if (listener.hasSensor(sensorObject)) {
                        listener.onSensorChangedLocked(sensorObject, values, timestamp, accuracy);
                    }
                    ++var9_14;
                }
            }
        }
    }

    public RdisSensorManager(Context context, ArrayList<RdisClient> clientList, ArrayList<RdisRemoteController> remoconList, RdisSensorManagerListener listener) {
        Dbg.i("RdisSensorManager", "RdisSensorManager, clientList: " + clientList);
        this.mContext = context;
        mClientList = clientList;
        mRemoconList = remoconList;
        this.mListener = listener;
    }

    private boolean enableSensor(ListenerDelegate listener, Sensor sensor, int delay) {
        Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start");
        int clientId = -100;
        for (RdisClient client : mClientList) {
            if (!client.getSensorList(sensor.getType()).contains(sensor)) continue;
            clientId = client.getMobileId();
            break;
        }
        if (clientId == -100) {
            for (RdisRemoteController remocon : mRemoconList) {
                if (!remocon.getSensorList(sensor.getType()).contains(sensor)) continue;
                clientId = remocon.getMobileId();
                break;
            }
        }
        if (clientId == -100) {
            Dbg.w("RdisSensorManager", "enableSensor could not find the sensor, clientId: " + clientId + ", type: " + sensor.getType());
            return false;
        }
        if (this.mListener != null) {
            if (delay == -1) {
                this.mListener.stopSensorRequest(clientId, sensor.getType());
            } else {
                this.mListener.startSensorRequest(clientId, sensor.getType(), delay);
            }
        }
        Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start");
        Dbg.v("RdisSensorManager", "registerListener() listener: " + listener + ", sensor: " + sensor + ", rate: " + rate);
        if (listener == null || sensor == null) {
            return false;
        }
        int delay = -1;
        switch (rate) {
            case 0: {
                delay = 0;
                break;
            }
            case 1: {
                delay = 20000;
                break;
            }
            case 2: {
                delay = 60000;
                break;
            }
            case 3: {
                delay = 200000;
                break;
            }
            default: {
                delay = rate;
            }
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            ListenerDelegate l = null;
            for (ListenerDelegate i : sListeners) {
                if (i.getListener() != listener) continue;
                l = i;
                break;
            }
            if (l == null) {
                l = new ListenerDelegate(listener, sensor);
                boolean result = this.enableSensor(l, sensor, delay / 1000);
                if (result) {
                    sListeners.add(l);
                    sListeners.notify();
                }
            } else {
                boolean result = this.enableSensor(l, sensor, delay / 1000);
                if (result) {
                    l.addSensor(sensor);
                }
            }
        }
        Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(SensorEventListener listener, Sensor sensor) {
        Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start");
        Dbg.v("RdisSensorManager", "unregisterListener() listener: " + listener + ", sensor: " + sensor);
        if (listener == null || sensor == null) {
            return;
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int size = sListeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerDelegate l = sListeners.get(i);
                if (l.getListener() != listener) continue;
                this.enableSensor(l, sensor, -1);
                l.removeSensor(sensor);
                if (!l.getSensors().isEmpty()) break;
                sListeners.remove(i);
                break;
            }
        }
        Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end");
    }

    public int getClientId(Sensor sensor) {
        for (RdisClient rdisClient : mClientList) {
            if (!rdisClient.getSensorList(sensor.getType()).contains(sensor)) continue;
            return rdisClient.getMobileId();
        }
        for (RdisRemoteController rdisRemoteController : mRemoconList) {
            if (!rdisRemoteController.getSensorList(sensor.getType()).contains(sensor)) continue;
            return rdisRemoteController.getMobileId();
        }
        return -1;
    }

    public void setClientList(ArrayList<RdisClient> clientList) {
        Dbg.i("RdisSensorManager", "setClientList: " + clientList);
        mClientList = clientList;
    }

    static {
        sListeners = new ArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerDelegate {
        final SensorEventListener mSensorEventListener;
        private final ArrayList<Sensor> mSensorList = new ArrayList();
        private final Handler mHandler;
        private SensorEvent mValuesPool;
        private int mId;

        ListenerDelegate(SensorEventListener listener, Sensor sensor) {
            Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] start");
            this.mId = RdisSensorManager.this.listenerId++;
            this.mSensorEventListener = listener;
            Looper looper = RdisSensorManager.this.mContext.getMainLooper();
            this.mHandler = new Handler(looper){

                public void handleMessage(Message msg) {
                    SensorEvent t = (SensorEvent)msg.obj;
                    if (t.accuracy >= 0) {
                        ListenerDelegate.this.mSensorEventListener.onAccuracyChanged(t.sensor, t.accuracy);
                    }
                    ListenerDelegate.this.mSensorEventListener.onSensorChanged(t);
                    ListenerDelegate.this.returnToPool(t);
                }
            };
            this.addSensor(sensor);
            Dbg.d("RdisSensorManager", "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] end");
        }

        protected SensorEvent createSensorEvent() {
            try {
                Constructor<?>[] cts = Class.forName("android.hardware.SensorEvent").getDeclaredConstructors();
                cts[0].setAccessible(true);
                return (SensorEvent)cts[0].newInstance(3);
            }
            catch (SecurityException e) {
                Dbg.printStackTrace(e);
            }
            catch (ClassNotFoundException e) {
                Dbg.printStackTrace(e);
            }
            catch (IllegalArgumentException e) {
                Dbg.printStackTrace(e);
            }
            catch (InstantiationException e) {
                Dbg.printStackTrace(e);
            }
            catch (IllegalAccessException e) {
                Dbg.printStackTrace(e);
            }
            catch (InvocationTargetException e) {
                Dbg.printStackTrace(e);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SensorEvent getFromPool() {
            SensorEvent t = null;
            ListenerDelegate listenerDelegate = this;
            synchronized (listenerDelegate) {
                t = this.mValuesPool;
                this.mValuesPool = null;
            }
            if (t == null) {
                t = this.createSensorEvent();
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void returnToPool(SensorEvent t) {
            ListenerDelegate listenerDelegate = this;
            synchronized (listenerDelegate) {
                if (this.mValuesPool == null) {
                    this.mValuesPool = t;
                }
            }
        }

        Object getListener() {
            return this.mSensorEventListener;
        }

        int getId() {
            return this.mId;
        }

        void addSensor(Sensor sensor) {
            this.mSensorList.add(sensor);
        }

        void removeSensor(Sensor sensor) {
            this.mSensorList.remove(sensor);
        }

        boolean hasSensor(Sensor sensor) {
            return this.mSensorList.contains(sensor);
        }

        List<Sensor> getSensors() {
            return this.mSensorList;
        }

        void onSensorChangedLocked(Sensor sensor, float[] values, long[] timestamp, int accuracy) {
            SensorEvent t = this.getFromPool();
            float[] v = t.values;
            v[0] = values[0];
            v[1] = values[1];
            v[2] = values[2];
            t.timestamp = timestamp[0];
            t.accuracy = accuracy;
            t.sensor = sensor;
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = t;
            this.mHandler.sendMessage(msg);
        }
    }
}

