/**
 *  \brief    VP Os RTMon defines.
 *  \author   Aurelien Morelle <aurelien.morelle@parrot.com>
 *  \version  1.0
 *  \date     first release 2008/04/23
 */

#ifndef _OS_RTMON_H_
#define _OS_RTMON_H_

# define RTMON_NEED_DEFINITIONS

#ifdef RTMON_NEED_DEFINITIONS
# define RTMON_START(cfg)         do{}while(0)
# define RTMON_STOP()             do{}while(0)
# define RTMON_FLUSH(...)         do{}while(0)
# define RTMON_USTART(id)         do{}while(0)
# define RTMON_USTOP(id)          do{}while(0)
# define RTMON_UVAL(id,value)     do{}while(0)
#endif // RTMON_NEED_DEFINITIONS

typedef enum _RTMON_UEVENT_IDS_
{
  NON_LINEAR_FUSION_UEVENT=0,
  VIDEO_VLIB_ENCODE_EVENT=1,
  VIDEO_VLIB_BLOCKLINE_TO_MB=2,
  VIDEO_VLIB_QUANTIZE=3,
  VIDEO_VLIB_DOQUANTIZE=4,
  VIDEO_VLIB_PACKET=5,
  VIDEO_VLIB_DCT_COMPUTE_UEVENT=6,
  VIDEO_VLIB_DCT_WAIT_UEVENT=7,
  IPHONE_ACCELEROS=8,
  // free : UEVENT_09=9,
  BCM43XX_BCMSDIOH_UEVENT_10=10,
  BCM43XX_BCMSDIOH_UEVENT_11=11,
  OPPONENT_DETECTION_UEVENT=12,
  ME_COMPUTE_UEVENT=13,
  PICTURE_REDUCTION_UEVENT=14,
  TRACKING_PREPARE_UEVENT=15,
  TRACKING_COMPUTE_UEVENT=16,
  TRACKING_UPDATE_UEVENT=17,
  TRANSLATION_ESTIMATION_UEVENT=18,
  TRACKER_REPLACE_UEVENT=19,
  SDIO_P5P_PRIVATE_UEVENT_20=20,
  SDIO_P5P_PRIVATE_UEVENT_21=21,
  SDIO_P5P_PRIVATE_UEVENT_22=22,
  SDIO_P5P_PRIVATE_UEVENT_23=23,
  SDIO_P5P_PRIVATE_UEVENT_24=24,
  // free : UEVENT_25=25,
  VISION_LOOP_LED_DETECT_UEVENT=26,
  VISION_TEST_DETECT_UEVENT=27,
  // free : UEVENT_28=28,
  // free : UEVENT_29=29,
  // free : UEVENT_30=30,
  SDK_STAGE_TRANSFORM_UEVENT=31
}
RTMON_UEVENT_ID;

typedef enum _RTMON_UVAL_IDS_
{
  // todo ? ADC_FSM_STATE_UVAL=0,
  // todo ? ACQ_FSM_STATE_UVAL=1,
  // todo ? CTRL_FSM_STATE_UVAL=2,
  VISON_NUM_ANGLES_UVAL=3,
  // free : UVAL_04=4,
  // free : UVAL_05=5,
  // free : UVAL_06=6,
  // free : UVAL_07=7,
  // free : UVAL_08=8,
  // free : UVAL_09=9,
  BCM43XX_BCMSDIOH_UVAL_10=10,
  BCM43XX_BCMSDIOH_UVAL_11=11,
  BCM43XX_BCMSDIOH_UVAL_12=12,
  // free : UVAL_13=13,
  // free : UVAL_14=14,
  // free : UVAL_15=15,
  // free : UVAL_16=16,
  // free : UVAL_17=17,
  SDK_STAGE_INDEX_UVAL=18,
  // free : UVAL_19=19,
  SDIO_P5P_PRIVATE_UVAL_20=20,
  ICAMIF_SERVER_BLOCKLINE_UVAL=21,
  ICAMIF_CLIENT_BLOCKLINE_UVAL=22,
  ICAMIF_BLOCKLINE_UVAL=23,
  CAMIF_CONSUME=24,
  CAMIF_BLOCKLINE_UVAL=25,
  CAMIF_LINES_UVAL=26,
  CAPTURED_BLOCKLINE_UVAL=27,
  CAPTURED_PICTURE_UVAL=28,
  NB_TRACKERS_DEFINED_UVAL=29,
  ENCODED_BLOCKLINE_SIZE_UVAL=30,
  ENCODED_PICTURE_UVAL=31
}
RTMON_UVAL_ID;

#endif // _OS_RTMON_H_
