/**
 * @file main.c
 * @author sylvain.gaeremynck@parrot.com
 * @date 2009/07/01
 */
#include <ardrone_testing_tool.h>

//ARDroneLib
#include <utils/ardrone_time.h>
#include <ardrone_tool/Navdata/ardrone_navdata_client.h>
#include <ardrone_tool/Control/ardrone_control.h>
#include <ardrone_tool/UI/ardrone_input.h>

//Common
#include <config.h>
#include <ardrone_api.h>

//VP_SDK
#include <ATcodec/ATcodec_api.h>
#include <VP_Os/vp_os_print.h>
#include <VP_Api/vp_api_thread_helper.h>
#include <VP_Os/vp_os_signal.h>

//Local project
#include <Video/video_stage.h>

// TODO: remove this in final; not required
// Get keyboard input; return -1 if no input
#include <termios.h>
#include <unistd.h>
int kbhit(void) {
  struct termios oldt, newt;
  int ch;

  tcgetattr(STDIN_FILENO, &oldt);
  newt = oldt;

  newt.c_lflag &= ~( ICANON | ECHO );
  tcsetattr(STDIN_FILENO, TCSANOW, &newt);
  ch = getchar();
  tcsetattr(STDIN_FILENO, TCSANOW, &oldt);

  return ch;
}

static int32_t exit_ihm_program = 1;

/* Implementing Custom methods for the main function of an ARDrone application */
int main(int argc, char** argv)
{
	return ardrone_tool_main(argc, argv);
}

/* The delegate object calls this method during initialization of an ARDrone application */
C_RESULT ardrone_tool_init_custom(void)
{
  /* Registering for a new device of game controller */
  // ardrone_tool_input_add( &gamepad );

  /* Start all threads of your application */
  START_THREAD( video_stage, NULL );
  
  return C_OK;
}

/* The delegate object calls this method every time in the event loop */
C_RESULT ardrone_tool_update_custom() {
  static float phi = 0, theta = 0, gaz = 0, yaw = 0, psi = 0, psi_accuracy = 0;
  static int start = 0, emergency = 0, hover = 0, yaw_mode = 0, abs_ctrl_mode = 0;
  int key = kbhit();

  if (key == '1') {
    start = !start;
    ardrone_tool_set_ui_pad_start(start);
  }
  else if (key == '2') {
    emergency = !emergency;
    ardrone_tool_set_ui_pad_select(emergency);
  }
  else {
    #define _INC(_c, _v) case _c : _v += 0.1f; if ( _v >  1.0f) _v =  1.0f; break
    #define _DEC(_c, _v) case _c : _v -= 0.1f; if ( _v < -1.0f) _v = -1.0f; break
    switch (key) {
      _INC('q', phi);
      _INC('w', theta);
      _INC('e', gaz);
      _INC('r', yaw);
      _INC('t', psi);
      _INC('y', psi_accuracy);

      _DEC('a', phi);
      _DEC('s', theta);
      _DEC('d', gaz);
      _DEC('f', yaw);
      _DEC('g', psi);
      _DEC('h', psi_accuracy);

      case 'h': hover = !hover; break;
      case 'y': yaw_mode = !yaw_mode; break;
      default: key = -1;
    }
    #undef _INC
    #undef _DEC
    if (key != -1) {
      ardrone_tool_set_progressive_cmd(
        (hover? 1 : 0) | (yaw_mode? 2 : 0) | (abs_ctrl_mode? 4 : 0),
        phi, theta, gaz, yaw, psi, psi_accuracy
      );
      //ardrone_at_set_progress_cmd((hover? 1 : 0) | (yaw_mode? 2 : 0), phi, theta, gaz, yaw);
    }
  }

  if (key != -1) {
    printf(
      "  phi theta   gaz   yaw   psi p_acc\n"
      "%5.1f %5.1f %5.1f %5.1f %5.1f %5.1f%s%s%s%s%s\n",
      phi, theta, gaz, yaw, psi, psi_accuracy,
      (start? " / take-off" : " / land"), 
      (emergency? " / emergency" : ""),
      (hover? " / hovering" : ""), 
      (yaw_mode? " / phi+yaw turn" : " / yaw turn"),
      (abs_ctrl_mode? " / Absolute Control Mode" : "")
    );
  }  
  
  return C_OK;
}

/* The delegate object calls this method when the event loop exit */
C_RESULT ardrone_tool_shutdown_custom(void)
{
  /* Relinquish all threads of your application */
  JOIN_THREAD( video_stage );

  /* Unregistering for the current device */
  // ardrone_tool_input_remove( &gamepad );

  return C_OK;
}

/* The event loop calls this method for the exit condition */
bool_t ardrone_tool_exit()
{
  return exit_ihm_program == 0;
}

C_RESULT signal_exit()
{
  exit_ihm_program = 0;

  return C_OK;
}

/* Implementing thread table in which you add routines of your application and those provided by the SDK */
BEGIN_THREAD_TABLE
  THREAD_TABLE_ENTRY( ardrone_control, 20 )
  THREAD_TABLE_ENTRY( navdata_update, 20 )
  THREAD_TABLE_ENTRY( video_stage, 20 )
END_THREAD_TABLE

