/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.view.MotionEvent;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.DaemonCommnunicator;
import com.sony.rdis.receiver.DaemonCommnunicatorListener;
import com.sony.rdis.receiver.RdisClient;
import com.sony.rdis.receiver.RdisClientListener;
import com.sony.rdis.receiver.RdisDefaultSensorListener;
import com.sony.rdis.receiver.RdisGeneralCommunicationListener;
import com.sony.rdis.receiver.RdisHIDManager;
import com.sony.rdis.receiver.RdisRemoteController;
import com.sony.rdis.receiver.RdisRemoteControllerListener;
import com.sony.rdis.receiver.RdisSensorManager;
import com.sony.rdis.receiver.RdisSensorManagerListener;
import com.sony.rdis.receiver.ServiceCommunicator;
import com.sony.rdis.receiver.ServiceCommunicatorListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RdisManager
implements DaemonCommnunicatorListener,
ServiceCommunicatorListener,
RdisSensorManagerListener {
    private static final String logTag = "RDIS_LIB";
    private static RdisManager mRdisManager = new RdisManager();
    private static Activity mActiviy = null;
    public static RdisSensorManager sensor = null;
    public static RdisHIDManager mRdisHidManager = null;
    private static ArrayList<RdisClient> mClientList = null;
    private static ArrayList<RdisRemoteController> mRemoconList = null;
    private static RdisClientListener mRdisClientListener = null;
    private static RdisRemoteControllerListener mRemoteControllerListener = null;
    private static int mDefaultSensorMobile = -100;
    private static RdisDefaultSensorListener mDefaultSensorListener = null;
    private static DaemonCommnunicator mDaemonCommunicatior = null;
    private static RdisRemoteController mGeneralRemocon = null;
    private static ServiceCommunicator mServiceCommunicator = null;
    private static ServiceCommunicatorListener mServiceCommunicatorListener = null;
    private static RdisGeneralCommunicationListener mRdisGeneralCommunicationListener = null;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int REMOVED_UNEXPECTEDLY = -1;
    private static final int FIRST_REMOCON_ID = -1;
    private static final int DEFAULT_SENSOR_MOBILE_HAS_NOT_BEEN_NOTIFIED = -100;

    private RdisManager() {
        Dbg.i(logTag, "RdisManager __2011_09_13_A__");
    }

    public static RdisManager getRdisManager(Activity activity) {
        Dbg.i(logTag, "RdisManger::getRdisManger");
        mActiviy = activity;
        mClientList = new ArrayList();
        mRemoconList = new ArrayList();
        if (mDaemonCommunicatior == null) {
            mDaemonCommunicatior = new DaemonCommnunicator(mRdisManager);
        }
        if (sensor == null) {
            sensor = new RdisSensorManager((Context)activity, mClientList, mRemoconList, mRdisManager);
        }
        if (mRdisHidManager == null) {
            mRdisHidManager = new RdisHIDManager((Context)activity);
        }
        return mRdisManager;
    }

    public static RdisManager getRdisManager() {
        Dbg.i(logTag, "RdisManger::getRdisManger");
        return mRdisManager;
    }

    public void destroy() {
        mActiviy = null;
        if (mDaemonCommunicatior != null) {
            mDaemonCommunicatior.stopThread();
        }
        mDaemonCommunicatior = null;
        mRdisClientListener = null;
        mClientList = null;
        sensor = null;
        mRdisHidManager = null;
    }

    public boolean registerListener(RdisClientListener listener) {
        Dbg.d(logTag, "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + " start] " + "listener=" + listener);
        if (listener == null) {
            Dbg.e(logTag, "registerListener() argument:listener is illegal.");
            return false;
        }
        if (mRdisClientListener != null) {
            Dbg.i(logTag, "already registered!");
            return false;
        }
        mRdisClientListener = listener;
        if (!mClientList.isEmpty()) {
            Dbg.v(logTag, "onStatusChanged(ADDED) from registerListener()");
            mRdisClientListener.onStatusChanged(1, mClientList);
        }
        Dbg.d(logTag, "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + " end] ");
        return true;
    }

    public void unregisterListener(RdisClientListener listener) {
        Dbg.d(logTag, "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + " start] ");
        mRdisClientListener = null;
        Dbg.d(logTag, "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + " end] ");
    }

    public boolean registerRemoteControllerListener(RdisRemoteControllerListener listener) {
        if (listener == null) {
            Dbg.e(logTag, "registerRemoteControllerListener() argument:listener is invalid.");
            return false;
        }
        if (mRemoteControllerListener != null) {
            Dbg.e(logTag, "registerRemoteControllerListener(): already registered.");
            return false;
        }
        mRemoteControllerListener = listener;
        for (RdisRemoteController remocon : mRemoconList) {
            mRemoteControllerListener.onConnected(remocon);
        }
        if (mGeneralRemocon != null) {
            mRemoteControllerListener.onConnected(mGeneralRemocon);
        }
        return true;
    }

    public void unregisterRemoteControllerListener() {
        mRemoteControllerListener = null;
    }

    public boolean registerDefaultSensorListener(RdisDefaultSensorListener listener) {
        if (listener == null) {
            Dbg.e(logTag, "registerDefaultSensorListener() argument:listener is invalid.");
            return false;
        }
        if (mDefaultSensorListener != null) {
            Dbg.e(logTag, "registerDefaultSensorListener(): already registered.");
            return false;
        }
        mDefaultSensorListener = listener;
        if (mDefaultSensorMobile != -100) {
            mDefaultSensorListener.onDefaultSensorChanged(mDefaultSensorMobile);
        }
        return true;
    }

    public void unregisterDefaultSensorListener() {
        mDefaultSensorListener = null;
    }

    public void mobileConnection(int mobileId, RdisClient client) {
        mClientList.add(client);
        ArrayList<RdisClient> clientList = new ArrayList<RdisClient>();
        clientList.add(client);
        Dbg.d(logTag, "[" + new Throwable().getStackTrace()[0].getFileName() + ":" + new Throwable().getStackTrace()[0].getClassName() + ":" + new Throwable().getStackTrace()[0].getMethodName() + ":" + new Throwable().getStackTrace()[0].getLineNumber() + "] " + "mRdisClientListener=" + mRdisClientListener);
        if (mRdisClientListener != null) {
            mRdisClientListener.onStatusChanged(1, clientList);
        }
    }

    public void mobileDisconnection(int mobileId) {
        Iterator<RdisClient> iterator = mClientList.iterator();
        while (iterator.hasNext()) {
            RdisClient client = iterator.next();
            if (client.getMobileId() != mobileId) continue;
            iterator.remove();
            ArrayList<RdisClient> clientList = new ArrayList<RdisClient>();
            clientList.add(client);
            if (mRdisClientListener == null) continue;
            mRdisClientListener.onStatusChanged(2, clientList);
        }
    }

    public void sensorEvent(int mobileId, int sensorType, float[] value, int accuracy) {
        sensor.recvSensorEvent(mobileId, sensorType, value, accuracy);
    }

    public void remoconConnection(RdisRemoteController controller) {
        mRemoconList.add(controller);
        if (mRemoteControllerListener != null) {
            mRemoteControllerListener.onConnected(controller);
        }
    }

    public void defaultSensorChange(int mobileId) {
        mDefaultSensorMobile = mobileId;
        if (mDefaultSensorListener != null) {
            mDefaultSensorListener.onDefaultSensorChanged(mobileId);
        }
    }

    public void touchEvent(int mobileId, MotionEvent event) {
        mRdisHidManager.recvTouchEvent(mobileId, event);
    }

    public void daemonConnectionFail() {
        mGeneralRemocon = new RdisRemoteController(-1);
        if (mActiviy != null) {
            SensorManager sensorManager = (SensorManager)mActiviy.getSystemService("sensor");
            List sensors = sensorManager.getSensorList(-1);
            for (Sensor sensor : sensors) {
                mGeneralRemocon.addSensor(sensor);
            }
        }
        if (mRemoteControllerListener != null) {
            mRemoteControllerListener.onConnected(mGeneralRemocon);
        }
        this.defaultSensorChange(-1);
    }

    public void fatalError(String error) {
        Dbg.e(logTag, "fatalError: " + error);
    }

    public void recvData(int mobileId, String name, String value) {
    }

    public void startSensorRequest(int mobileId, int sensorType, int delay) {
        mDaemonCommunicatior.startSensor(mobileId, sensorType, delay);
    }

    public void stopSensorRequest(int mobileId, int sensorType) {
        mDaemonCommunicatior.stopSensor(mobileId, sensorType);
    }

    public void initGeneralCommunication(Activity activity, String protocolName, RdisGeneralCommunicationListener listener) {
        mRdisGeneralCommunicationListener = listener;
        mServiceCommunicatorListener = new ServiceCommunicatorListener(){

            public void recvData(int mobileId, String name, String value) {
                if (mRdisGeneralCommunicationListener != null) {
                    mRdisGeneralCommunicationListener.onRecvData(mobileId, name, value);
                }
            }
        };
        mServiceCommunicator = new ServiceCommunicator((Context)activity, mServiceCommunicatorListener, protocolName);
    }

    public void destroyGeneralCommunication() {
        mServiceCommunicator.destroy();
        mServiceCommunicatorListener = null;
    }

    public void sendGeneralCommunication(int mobileId, String name, String value) {
        if (mServiceCommunicator != null) {
            mServiceCommunicator.sendData(mobileId, name, value);
        }
    }

    public void vibrate(int mobileId, long milliseconds) {
        mDaemonCommunicatior.vibrate(mobileId, milliseconds);
    }
}

