/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.common;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import com.sony.rdis.common.Dbg;
import com.sony.rdis.common.SocketConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class LocalConnection
implements SocketConnection {
    private static final String logTag = "RDIS_COMMON";
    private final int MAX_DATA_LENGTH = 0x100000;
    private LocalSocket mSocket = null;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;

    public boolean connect(String destination, int number) {
        boolean ret = false;
        if (this.isConnected()) {
            this.disconnect();
        }
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress socketAddress = new LocalSocketAddress(destination, LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(socketAddress);
            this.mInputStream = this.mSocket.getInputStream();
            this.mOutputStream = this.mSocket.getOutputStream();
            ret = true;
        }
        catch (Exception e) {
            Dbg.printStackTrace(e);
            this.disconnect();
        }
        return ret;
    }

    public void disconnect() {
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException e) {
                Dbg.printStackTrace(e);
            }
            this.mSocket = null;
        }
        this.mInputStream = null;
        this.mOutputStream = null;
    }

    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected();
    }

    public byte[] read(int length) throws IOException {
        if (length > 0x100000) {
            Dbg.e(logTag, "ERROR; read request size");
            return null;
        }
        if (!this.isConnected()) {
            Dbg.e(logTag, "ERROR; socket disconnected.");
            return null;
        }
        byte[] buffer = new byte[length];
        try {
            int readSize;
            for (int readLength = 0; readLength < length; readLength += readSize) {
                readSize = this.mInputStream.read(buffer, readLength, length - readLength);
                if (readSize > 0) continue;
                throw new IOException();
            }
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            this.disconnect();
            buffer = null;
            throw new IOException();
        }
        return buffer;
    }

    public boolean write(byte[] data) throws IOException {
        if (data.length <= 0 || data.length > 0x100000) {
            Dbg.e(logTag, "ERROR; data is empty or large." + data.length);
            return false;
        }
        if (!this.isConnected()) {
            Dbg.e(logTag, "ERROR; socket disconnected.");
            return false;
        }
        try {
            this.mOutputStream.write(data);
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            throw new IOException();
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            throw new IOException();
        }
        return true;
    }
}

