/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver.utility;

import com.sony.rdis.common.Dbg;
import com.sony.rdis.receiver.RdisManager;
import com.sony.rdis.receiver.utility.RdisUtilityGamePadInfo;
import com.sony.rdis.receiver.utility.RdisUtilityKeyConfiguration;
import org.json.JSONException;
import org.json.JSONObject;

public class RdisUtilityGamePad {
    private static final String logTag = "RDIS_UTIL";
    private boolean mRemoconGamePad;
    private int mDeviceId;
    private int[] mSensorType;
    private RdisUtilityGamePadInfo mRdisUtilityGamePadInfo = null;

    public RdisUtilityGamePad(boolean remoconGamePad, int deviceId, int[] sensorType, RdisUtilityGamePadInfo info) {
        this.mRemoconGamePad = remoconGamePad;
        this.mDeviceId = deviceId;
        this.mSensorType = sensorType;
        this.mRdisUtilityGamePadInfo = info;
    }

    public boolean isDefaultGamePad() {
        return this.mRemoconGamePad;
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public String getNickname() {
        if (this.mRdisUtilityGamePadInfo == null) {
            return null;
        }
        return this.mRdisUtilityGamePadInfo.mNickname;
    }

    public String getMacAddress() {
        if (this.mRdisUtilityGamePadInfo == null) {
            return null;
        }
        return this.mRdisUtilityGamePadInfo.mMacAddress;
    }

    public int[] getSensorType() {
        return this.mSensorType;
    }

    public void vibrate(long milliseconds) {
        RdisManager.getRdisManager().vibrate(this.mDeviceId, milliseconds);
    }

    public void setKeyConfig(RdisUtilityKeyConfiguration keyConfig) {
        if (this.mRdisUtilityGamePadInfo != null && !this.mRdisUtilityGamePadInfo.mRegisteredFlag) {
            return;
        }
        if (keyConfig == null) {
            RdisManager.getRdisManager().sendGeneralCommunication(this.mDeviceId, "UNSET_KEY_CONFIG", "");
        } else {
            JSONObject jobj = new JSONObject();
            try {
                if (keyConfig.useAnalogStick) {
                    jobj.put("DIRECTIONAL", (Object)"ANALOG");
                } else {
                    jobj.put("DIRECTIONAL", (Object)"DIGITAL");
                }
                jobj.put("DIRECTIONAL_KEY_UP", keyConfig.keyUp);
                jobj.put("DIRECTIONAL_KEY_DOWN", keyConfig.keyDown);
                jobj.put("DIRECTIONAL_KEY_LEFT", keyConfig.keyLeft);
                jobj.put("DIRECTIONAL_KEY_RIGHT", keyConfig.keyRight);
                jobj.put("KEY_A", keyConfig.keyA);
                jobj.put("KEY_B", keyConfig.keyB);
                jobj.put("KEY_C", keyConfig.keyC);
                jobj.put("KEY_D", keyConfig.keyD);
            }
            catch (JSONException e) {
                Dbg.e((String)logTag, (String)("ERROR :" + (Object)((Object)e)));
                return;
            }
            RdisManager.getRdisManager().sendGeneralCommunication(this.mDeviceId, "SET_KEY_CONFIG", jobj.toString());
            Object var2_2 = null;
        }
    }

    public void setUserColor(int userColor) {
        if (this.mRdisUtilityGamePadInfo != null && !this.mRdisUtilityGamePadInfo.mRegisteredFlag) {
            return;
        }
        if (userColor == 0) {
            RdisManager.getRdisManager().sendGeneralCommunication(this.mDeviceId, "UNSET_USER_COLOR", "");
        } else {
            JSONObject jobj = new JSONObject();
            try {
                jobj.put("USER_COLOR", (Object)("0x" + Integer.toHexString(userColor)));
            }
            catch (JSONException e) {
                Dbg.e((String)logTag, (String)("ERROR :" + (Object)((Object)e)));
                return;
            }
            RdisManager.getRdisManager().sendGeneralCommunication(this.mDeviceId, "SET_USER_COLOR", jobj.toString());
            Object var2_2 = null;
        }
    }
}

