/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import com.sony.rdis.receiver.RdisOnTouchListener;
import java.util.ArrayList;

public class RdisHIDManager {
    private Context mContext;
    private static ArrayList<ListenerDelegate> sListeners = new ArrayList();

    public RdisHIDManager(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerOnTouchListener(int mobileId, RdisOnTouchListener listener) {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            ListenerDelegate l = null;
            for (ListenerDelegate i : sListeners) {
                if (i.getListener() != listener) continue;
                l = i;
                break;
            }
            if (l == null) {
                l = new ListenerDelegate(mobileId, listener);
                sListeners.add(l);
            } else {
                l.addMobile(mobileId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnTouchListener(int mobileId, RdisOnTouchListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int size = sListeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerDelegate l = sListeners.get(i);
                if (l.getListener() != listener) continue;
                if (l.removeMobile(mobileId) != 0) break;
                sListeners.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recvTouchEvent(int mobileId, MotionEvent event) {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            if (sListeners.isEmpty()) {
                return;
            }
            for (ListenerDelegate listener : sListeners) {
                if (!listener.hasMobile(mobileId)) continue;
                listener.onTouchEventLocked(mobileId, event);
            }
        }
    }

    private class ListenerDelegate {
        final RdisOnTouchListener mTouchEventListener;
        private final Handler mHandler;
        public SparseBooleanArray mMobiles = new SparseBooleanArray();

        ListenerDelegate(int mobileId, RdisOnTouchListener listener) {
            this.mTouchEventListener = listener;
            Looper looper = RdisHIDManager.this.mContext.getMainLooper();
            this.mHandler = new Handler(looper){

                public void handleMessage(Message msg) {
                    MotionEvent event = (MotionEvent)msg.obj;
                    ListenerDelegate.this.mTouchEventListener.onTouchEvent(event);
                }
            };
            this.addMobile(mobileId);
        }

        Object getListener() {
            return this.mTouchEventListener;
        }

        void addMobile(int mobileId) {
            this.mMobiles.put(mobileId, true);
        }

        int removeMobile(int mobileId) {
            this.mMobiles.delete(mobileId);
            return this.mMobiles.size();
        }

        boolean hasMobile(int mobileId) {
            return this.mMobiles.get(mobileId);
        }

        void onTouchEventLocked(int mobileId, MotionEvent event) {
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = event;
            this.mHandler.sendMessage(msg);
        }
    }
}

