/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.common;

import com.sony.rdis.common.Dbg;
import com.sony.rdis.common.SocketConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class TcpConnection
implements SocketConnection {
    private static final String logTag = "RDIS_COMMON";
    private final int SOCKET_TIMEOUT = 1000;
    private final int MAX_TCP_DATA_LENGTH = 0x100000;
    private Socket mSocket = null;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;

    public synchronized boolean connect(String destination, int number) {
        InetAddress address;
        boolean ret = false;
        if (this.isConnected()) {
            this.disconnect();
        }
        try {
            String[] b = destination.split("\\.");
            byte[] ipAddress = new byte[]{(byte)Integer.parseInt(b[0]), (byte)Integer.parseInt(b[1]), (byte)Integer.parseInt(b[2]), (byte)Integer.parseInt(b[3])};
            address = null;
            address = InetAddress.getByAddress(ipAddress);
        }
        catch (UnknownHostException e) {
            Dbg.printStackTrace(e);
            return ret;
        }
        catch (NumberFormatException e) {
            Dbg.printStackTrace(e);
            return ret;
        }
        try {
            Dbg.i(logTag, "TCP CONNECT TO :" + address.getHostAddress() + ":" + number);
            this.mSocket = new Socket();
            this.mSocket.setReuseAddress(true);
            this.mSocket.connect(new InetSocketAddress(address, number), 1000);
            this.mInputStream = this.mSocket.getInputStream();
            this.mOutputStream = this.mSocket.getOutputStream();
            ret = true;
        }
        catch (Exception e) {
            Dbg.printStackTrace(e);
            this.disconnect();
        }
        return ret;
    }

    public synchronized void disconnect() {
        if (this.mSocket != null) {
            try {
                this.mSocket.shutdownInput();
                this.mSocket.shutdownOutput();
                this.mSocket.close();
            }
            catch (IOException e) {
                Dbg.printStackTrace(e);
            }
            this.mSocket = null;
        }
        this.mInputStream = null;
        this.mOutputStream = null;
    }

    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected();
    }

    public byte[] read(int length) throws IOException {
        if (length > 0x100000) {
            Dbg.e(logTag, "ERROR; read request size");
            return null;
        }
        if (!this.isConnected()) {
            Dbg.e(logTag, "ERROR; socket disconnected.");
            return null;
        }
        byte[] buffer = new byte[length];
        try {
            int readSize;
            for (int readLength = 0; readLength < length; readLength += readSize) {
                readSize = this.mInputStream.read(buffer, readLength, length - readLength);
                if (readSize > 0) continue;
                throw new IOException();
            }
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            this.disconnect();
            buffer = null;
            throw new IOException();
        }
        catch (NullPointerException e) {
            Dbg.printStackTrace(e);
            this.disconnect();
            buffer = null;
            throw new IOException();
        }
        return buffer;
    }

    public synchronized boolean write(byte[] data) throws IOException {
        if (data.length <= 0 || data.length > 0x100000) {
            Dbg.e(logTag, "ERROR; data is empty or large." + data.length);
            return false;
        }
        if (!this.isConnected()) {
            Dbg.e(logTag, "ERROR: tcp socket disconnected.");
            return false;
        }
        try {
            this.mOutputStream.write(data);
        }
        catch (UnsupportedEncodingException e) {
            Dbg.printStackTrace(e);
            throw new IOException();
        }
        catch (IOException e) {
            Dbg.printStackTrace(e);
            throw new IOException();
        }
        return true;
    }
}

