/*
 * Decompiled with CFR 0.152.
 */
package com.sony.rdis.receiver;

import android.hardware.Sensor;
import com.sony.rdis.receiver.HumanInterfaceDeviceInfomation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdisClient {
    private int mMobileId = -1;
    private ArrayList<Sensor> mSensorList = new ArrayList();
    private List<HumanInterfaceDeviceInfomation> mHidList = new ArrayList<HumanInterfaceDeviceInfomation>();
    private boolean mEnableGpCommunication = false;
    private String mProtocolName = null;

    public RdisClient(int mobileId) {
        this.mMobileId = mobileId;
    }

    public void addSensor(Sensor sensor) {
        this.mSensorList.add(sensor);
    }

    public void addHid(HumanInterfaceDeviceInfomation hid) {
        this.mHidList.add(hid);
    }

    public void setGpCommunication(boolean enableflag, String protocolName) {
        this.mEnableGpCommunication = enableflag;
        this.mProtocolName = protocolName;
    }

    public int getMobileId() {
        return this.mMobileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sensor> getSensorList(int type) {
        List<Object> list;
        ArrayList<Sensor> fullList;
        ArrayList<Sensor> arrayList = fullList = this.mSensorList;
        synchronized (arrayList) {
            if (type == -1) {
                list = fullList;
            } else {
                list = new ArrayList();
                for (Sensor i : fullList) {
                    if (i.getType() != type) continue;
                    list.add(i);
                }
            }
            list = Collections.unmodifiableList(list);
        }
        return list;
    }

    public int getKeyDeviceId() {
        return this.getDeviceId(1);
    }

    public int getTouchPanelDeviceId() {
        return this.getDeviceId(2);
    }

    public int getMouseDeviceId() {
        return this.getDeviceId(3);
    }

    private int getDeviceId(int deviceType) {
        for (HumanInterfaceDeviceInfomation di : this.mHidList) {
            if (di.getDeviceType() != deviceType) continue;
            return di.getDeviceId();
        }
        return -1;
    }
}

