﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
public class LogScaleSlider : MonoBehaviour
{
    [SerializeField]
    Text text;

    Scrollbar slider;


    // Start is called before the first frame update
    void Start()
    {
        slider = GetComponent<Scrollbar>();
    }

    
    public float GetLogScaleValue()
    {
        return (-1) * Mathf.Pow(10, slider.value * (-4)) + 1;
    }

    public void UpdateLogScaleText()
    {
        text.text = GetLogScaleValue() + "c";
    }

    public void UpdateValuebyVelocity(float v)
    {
        slider.value = Mathf.Log10(1 - v) * -(1.0f/4.0f);
    }

}
