﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;
using UnityEngine.UI;

public class AlertManager : MonoBehaviour
{
    [SerializeField]
    GameObject alertObject;
    [SerializeField]
    Button okButton;
    [SerializeField]
    Button cancelButton;
    [SerializeField]
    Text alertText;

    Queue<string> alertTextQueue;

    // Start is called before the first frame update
    void Start()
    {
        Close();
        //string[] aa = { "a","b" };
        //Alert(aa);
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void Alert(string text,UnityAction ok = null,UnityAction cancel = null)
    {
        Open();
        alertText.text = text;
        okButton.onClick.AddListener(Close);
        cancelButton.onClick.AddListener(Close);

        if(ok != null)
        {
            okButton.onClick.AddListener(ok);
        }

        if(cancel != null)
        {
            cancelButton.onClick.AddListener(cancel);
        }
    }

    public void Alert(IList<string> texts)
    {
        alertTextQueue = new Queue<string>(texts);
        AlertQueue();
    }


    public void AlertQueue()
    {
        if(alertTextQueue.Count >= 2)
        {
            Alert(alertTextQueue.Dequeue(), AlertQueue, DeleteQueue);
        }
        else
        {
            Alert(alertTextQueue.Dequeue());
        }
    }

    public void DeleteQueue()
    {
        alertTextQueue.Clear();
    }

    public void Open()
    {
        Time.timeScale = 0.0f;
        alertObject.SetActive(true);
    }
    public void Close()
    {
        Time.timeScale = 1.0f;
        okButton.onClick.RemoveAllListeners();
        cancelButton.onClick.RemoveAllListeners();
        alertObject.SetActive(false);
    }
}
