﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Linq;
using UnityEngine.UI;
using System;

public class PathRenderer : MonoBehaviour
{
    [SerializeField]
    Square square;
    [SerializeField]
    GameObject PathColliderPrefab;
    [SerializeField]
    Camera playercamera;
    [SerializeField]
    LevelManager levelManager;
    [SerializeField]
    GameObject background;
    [SerializeField]
    LogScaleSlider velocityslider;

    LineRenderer _pathRenderer;
    float _originalPathColliderY;
    // Start is called before the first frame update
    void Start()
    {
        _originalPathColliderY = PathColliderPrefab.transform.localScale.y / 2;

        _pathRenderer = GetComponent<LineRenderer>();
        _ResetPaths();
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetMouseButtonDown(1) && levelManager.player.isInertial())
        {
            RaycastHit hit;
            var ray = Camera.main.ScreenPointToRay(Input.mousePosition);

            if (Physics.Raycast(ray, out hit))
            {
                ray = playercamera.ViewportPointToRay(hit.textureCoord);
                if (Physics.Raycast(ray, out hit))
                {
                    if (Input.GetKey(KeyCode.LeftShift))
                    {
                        _DrawMorePath(hit.point);
                    }
                    else
                    {
                        _DrawOnePath(hit.point);
                    }
                }
            }
            /*if (Physics.Raycast(ray, out hit))
            {
                if (Input.GetKey(KeyCode.LeftShift))
                {
                    _DrawMorePath(hit.point);
                }
                else
                {
                    _DrawOnePath(hit.point);
                }
            }*/
        }
    }

    private void _DrawOnePath(Vector3 point)
    {
        _ResetPaths();
        square.pathList[0] = transform.localPosition;
        square.pathVelocity[0] = 0.0f;
        var tmp = transform.InverseTransformPoint(point);
        square.pathList[1] = new Vector3(tmp.x, tmp.y, 0.0f);
        square.pathVelocity[1] = velocityslider.GetLogScaleValue();
        _pathRenderer.SetPositions(square.pathList.ToArray());
        _InstantiatePathCollider(0);
    }

    private void _ResetPaths()
    {
        _pathRenderer.positionCount = 2;
        square.pathList.Clear();
        square.pathVelocity.Clear();
        square.pathList.Add(transform.localPosition);
        square.pathVelocity.Add(0.0f);
        square.pathList.Add(transform.localPosition);
        square.pathVelocity.Add(0.0f);
        _pathRenderer.SetPositions(square.pathList.ToArray());
        for (int i = 0; i < transform.childCount; i++)
        {
            Destroy(transform.GetChild(i).gameObject);
        }
    }

    private void _DrawMorePath(Vector3 point)
    {
        if (square.pathList.Count == 0)
        {
            _DrawOnePath(point);
        }
        else
        {
            var tmp = transform.InverseTransformPoint(point);
            square.pathList.Add(new Vector3(tmp.x, tmp.y, 0.0f));
            square.pathVelocity.Add(velocityslider.GetLogScaleValue());
            _pathRenderer.positionCount = square.pathList.Count();
            _pathRenderer.SetPositions(square.pathList.ToArray());
            _InstantiatePathCollider(square.pathList.Count() - 2);
        }
    }

    private void _InstantiatePathCollider(int n)
    {
        var _pathCollider = Instantiate(PathColliderPrefab, transform);
        _pathCollider.name = "PathCollider-" + n;
        _pathCollider.tag = "path";
        _pathCollider.transform.localScale = new Vector3(0.1f, _originalPathColliderY, 0);
        _pathCollider.transform.localEulerAngles = new Vector3(0, 0,
            (float)Constants.RadianToDegree(Mathf.PI / 2 +
                Mathf.Atan
                (square.GetTangent(
                    square.GetNthPath(n)))));

        float _newY = square.GetNthPath(n).magnitude;
        _pathCollider.transform.localScale = new Vector3(0.1f, _newY * _originalPathColliderY, 0);

        _pathCollider.transform.localPosition = (square.pathList[n] + square.pathList[n + 1]) / 2;
    }
}
