﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public static class Constants
{
    public static double c => 5; // speed of light.
    public static double Gamma(double v)
    {
        return 1.0f / Mathf.Sqrt((1 - (float)((v / c) * (v / c))));
    }

    public static double RadianToDegree(double r)
    {
        return r * 180 / Mathf.PI;
    }
}
