﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraMovement : MonoBehaviour
{

    public LevelManager Levelmanager;

    Camera thecamera;
    double aspect;
    //public double playergamma;
    // Start is called before the first frame update
    void Start()
    {
        //playergamma = 1.0f;
        thecamera = GetComponent<Camera>();
        aspect = 16.0f / 9.0f;
    }

    // Update is called once per frame
    void FixedUpdate()
    {
        transform.position = Levelmanager.player.transform.position;

        
        var v = Levelmanager.player.v;
        var vt = v + Vector3.up;

        vt.x = -vt.x;

        vt.z = -vt.z;

        vt.Normalize();

        Vector3 newforward = new Vector3(vt.y * (v.x / v.magnitude), Mathf.Sqrt(vt.x * vt.x + vt.z * vt.z), vt.y * (v.z / v.magnitude));

        transform.rotation = Quaternion.LookRotation(-vt, newforward);

        thecamera.orthographicSize = 10.0f * ((float)Levelmanager.player.gamma); // number is size of camera

        aspect = 16.0f / (9.0f * (Levelmanager.player.gamma));

        thecamera.aspect = (float)aspect;

        transform.Translate(-Vector3.forward * 50); // number is distance of camera from player

    }
}
