﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Linq;
using UnityEngine.UI;
using System;

public class PathRenderer : MonoBehaviour
{
    [SerializeField]
    Square square;
    [SerializeField]
    GameObject PathColliderPrefab;
    [SerializeField]
    Camera playercamera;
    [SerializeField]
    LevelManager levelManager;
    [SerializeField]
    BackgroundMovement background;
    [SerializeField]
    LogScaleSlider velocityslider;

    LineRenderer _pathRenderer;
    float _originalPathColliderY;

    public BackgroundMovement Background 
    {
        get 
        {
            return background;
        }
        set
        {
            background = value;
        }
    }

    // Start is called before the first frame update
    void Start()
    {
        _originalPathColliderY = PathColliderPrefab.transform.localScale.y / 2;

        _pathRenderer = GetComponent<LineRenderer>();
        _ResetPaths();
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetMouseButtonDown(1) && levelManager.player.isInertial())
        {
            RaycastHit hit;
            var ray = Camera.main.ScreenPointToRay(Input.mousePosition);

            if (Physics.Raycast(ray, out hit))
            {
                ray = playercamera.ViewportPointToRay(hit.textureCoord);
                if (Physics.Raycast(ray, out hit))
                {
                    if (Input.GetKey(KeyCode.LeftShift))
                    {
                        _DrawMorePath(hit.point);
                    }
                    else
                    {
                        _DrawOnePath(hit.point);
                    }
                }
            }
            /*if (Physics.Raycast(ray, out hit))
            {
                if (Input.GetKey(KeyCode.LeftShift))
                {
                    _DrawMorePath(hit.point);
                }
                else
                {
                    _DrawOnePath(hit.point);
                }
            }*/
        }
    }

    private void _DrawOnePath(Vector3 point)
    {
        _ResetPaths();
        square.pathList[0] = transform.localPosition;
        square.pathVelocity[0] = 0.0f;
        var tmp = transform.InverseTransformPoint(point);
        square.pathList[1] = new Vector3(tmp.x, tmp.y, 0.0f);
        square.pathVelocity[1] = velocityslider.GetLogScaleValue();
        _pathRenderer.SetPositions(square.pathList.ToArray());
        _InstantiatePathCollider(0);
    }

    private void _ResetPaths()
    {
        _pathRenderer.positionCount = 2;
        square.pathList.Clear();
        square.pathVelocity.Clear();
        square.pathList.Add(transform.localPosition);
        square.pathVelocity.Add(0.0f);
        square.pathList.Add(transform.localPosition);
        square.pathVelocity.Add(0.0f);
        _pathRenderer.SetPositions(square.pathList.ToArray());
        for (int i = 0; i < transform.childCount; i++)
        {
            Destroy(transform.GetChild(i).gameObject);
        }
    }

    private void _DrawMorePath(Vector3 point)
    {
        if (square.pathList.Count == 0)
        {
            _DrawOnePath(point);
        }
        else
        {
            var tmp = transform.InverseTransformPoint(point);
            square.pathList.Add(new Vector3(tmp.x, tmp.y, 0.0f));
            square.pathVelocity.Add(velocityslider.GetLogScaleValue());
            _pathRenderer.positionCount = square.pathList.Count();
            _pathRenderer.SetPositions(square.pathList.ToArray());
            _InstantiatePathCollider(square.pathList.Count() - 2);
        }
    }

    public void PathClear()
    {
        _ResetPaths();
    }

    /// <summary>
    /// 현재 설정된 경로를 반환.
    /// 0번은 내 위치
    /// x y 가 공간 z 가 시간
    /// </summary>
    public List<Vector3> PathPositionsXY
    {
        get
        {
            return square.pathList;
        }
    }
    /// <summary>
    /// 현재 설정된 경로를 반환.
    /// 0번은 현재위치 //패트롤 고려
    /// x z 가 공간 y 가 시간
    /// </summary>
    public List<Vector3> PathPositionsXZ
    {
        get
        {
            List<Vector3> list = new List<Vector3>();

            foreach(var a in square.pathList)
            {
                //xy -> xz
                list.Add(new Vector3(a.x, 0, a.y));
            }

            return list;
        }
    }
    /// <summary>
    /// 현재 설정된 경로의 속력을 반환.
    /// 0번은 0.0f
    /// </summary>
    public List<float> PathVelocities
    {
        get
        {
            return new List<float>(square.pathVelocity);
        }
    }
    private void _InstantiatePathCollider(int n)
    {
        var _pathCollider = Instantiate(PathColliderPrefab, transform);
        _pathCollider.name = "PathCollider-" + n;
        _pathCollider.tag = "path";
        _pathCollider.transform.localScale = new Vector3(0.1f, _originalPathColliderY, 0);
        _pathCollider.transform.localEulerAngles = new Vector3(0, 0,
            (float)Constants.RadianToDegree(Mathf.PI / 2 +
                Mathf.Atan
                (square.GetTangent(
                    square.GetNthPath(n)))));

        float _newY = square.GetNthPath(n).magnitude;
        _pathCollider.transform.localScale = new Vector3(0.1f, _newY * _originalPathColliderY, 0);

        _pathCollider.transform.localPosition = (square.pathList[n] + square.pathList[n + 1]) / 2;
    }

    public IEnumerator _StartMovingPath(int finalPathNum)
    {
        int i = 0;
        var u = levelManager.player.v;
        int tinterval = Constants.alphatinterval;

        while (i <= finalPathNum)
        {
            Vector3 acceleration = new Vector3(square.GetNthPath(i).x, 0f, square.GetNthPath(i).y);

            var offsetstartpos = Background.transform.position;
            var startpos = levelManager.player.transform.position;

            acceleration = acceleration.normalized;

            var deltat = Time.fixedDeltaTime * tinterval;

            var v = square.GetPathVelocity(i);

            acceleration = (float)((Constants.c / deltat) * MathNet.Numerics.Trig.Asinh(v * Constants.Gamma(v * Constants.c))) * acceleration;
            // acceleration required to accelerate to v in deltat seconds: see https://en.wikiversity.org/wiki/Theory_of_relativity/Rindler_coordinates

            var startv = levelManager.player.v;

            levelManager.player.alpha = acceleration;

            for (var j = 0; j < tinterval; ++j)
            {
                yield return new WaitForFixedUpdate();
            }
            levelManager.player.alpha = new Vector3(0, 0, 0);
            var offsetnewpos = Background.transform.position;
            var newpos = levelManager.player.transform.position;

            var posdiff = newpos - startpos;
            var offset = offsetnewpos - offsetstartpos;

            posdiff = posdiff - offset;
             
            while(true)
            {
                var tmp = (square.GetDestPoint(i) + Background.transform.position - levelManager.player.transform.position);
                if ((posdiff - tmp).magnitude < 0.01f)
                    break;
                yield return new WaitForFixedUpdate();
            }

            acceleration = -acceleration;

            levelManager.player.alpha = acceleration;

            for (var j = 0; j < tinterval; ++j)
            {
                yield return new WaitForFixedUpdate();
            }
            levelManager.player.alpha = new Vector3(0, 0, 0);


            Background.Toggle = true;

            break;

            i++;
        }

    }

    public void DeletePathsAfterNthPath(int n)
    {
        square.pathList.RemoveRange(n, _pathRenderer.positionCount - n);
        square.pathVelocity.RemoveRange(n, _pathRenderer.positionCount - n);
        for (int i = 0; i < transform.childCount; i++)
        {
            if (i + 1 >= n) Destroy(transform.GetChild(i).gameObject);
        }
        _pathRenderer.positionCount = square.pathList.Count();
    }
}
