﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BackgroundMovement : MonoBehaviour
{
    [SerializeField]
    GameObject Cone;
    bool grabbed = false;
    int cnt = 0;
    double beta = 0.5f; // v/c
    Vector3 alpha = new Vector3(0.1f, 0.0f, 0.0f); // proper acceleration
    Vector3 v;
    public LevelManager Levelmanager;
    public double starttime = 0.0f;
    public double gamma = 1.0f;
    Vector3 orientation;

    bool toggle = false;
    public bool Toggle
    {
        get
        {
            return toggle;
        }
        set
        {
            if(value)
                transform.parent = Cone.transform;
            else
            {
                transform.parent = null;
                v = Levelmanager.player.v;
            }

            toggle = value;
        }
    }

    // Start is called before the first frame update
    void Start()
    {
        toggle = true;
        v = new Vector3(0, 0, 0);
    }

    void FixedUpdate()
    {
        if(toggle)
        {
            transform.localPosition = new Vector3(0, 0, 0);
        }
        else
        {
            transform.Translate((float)Constants.c * Vector3.up * Time.fixedDeltaTime * (float)Levelmanager.player.gamma, Space.World); // move up by 1 second
            transform.Translate(v * Time.fixedDeltaTime * (float)Levelmanager.player.gamma, Space.World);
        }
    }
}
