﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LevelManager : MonoBehaviour
{

    public UIManager uiManager;

    public double gamma;
    public PlayerMovement player;
    [SerializeField]
    protected bool winstate = false;

    [SerializeField]
    protected bool DoubleClickMove = true;
    [SerializeField]
    protected bool PathRanderMove = true;
    [SerializeField]
    protected bool WASDMove = true;


    // Start is called before the first frame update
    protected virtual void Start()
    {
        winstate = false;


        uiManager.WASDMove = WASDMove;
        uiManager.PathCreateAble = PathRanderMove;
        uiManager.DoubleCLickMove = DoubleClickMove;
    }

    // Update is called once per frame
    protected virtual void Update()
    {
        if (WinCondition())
        {
            WinState = true;
        }

        if (LoseCondition())
        {
            WinState = false;
        }
    }

    protected virtual void OnWin()
    {
        uiManager.WinTextOn();
    }

    protected virtual void OnLose()
    {

    }

    protected virtual bool LoseCondition()
    {
        return false;
    }

    protected virtual bool WinCondition()
    {
        return false;
    }
    public virtual bool WinState
    {
        set
        {
            if (value)
            {
                //if win
                OnWin();
            }
            else
            {
                //if lose
                OnLose();
            }
        }
    }
}
