﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;
using System.Linq;

public class UIManager : MonoBehaviour
{
    [SerializeField]
    Square square;
    [SerializeField]
    Camera playercamera;

    public Canvas canvas;
    public Text mytime;
    //public Planemovement clock1;
    //public Planemovement clock2;
    //public Text clock1time;
    //public Text clock2time;
    public Text wintext;
    public GameObject _pathUI;
    public LevelManager Levelmanager;
    private int prevSelectPathNum = -1;
    private Text pathName;
    private Vector3 middlePoint;
    private Vector3 canvasSize;
    
    // Start is called before the first frame update
    void Start()
    {
        _pathUI.SetActive(false);
        pathName = _pathUI.transform.Find("Name").GetComponent<Text>();
        middlePoint = _pathUI.transform.position;
        canvasSize = new Vector3(Screen.width, Screen.height, 0);
    }

    // Update is called once per frame
    void Update()
    {
        mytime.text = Levelmanager.player.time.ToString() + " s";
        //clock1time.text = clock1.GetTime().ToString() + " s";
        //clock2time.text = clock2.GetTime().ToString() + " s";
        if(Levelmanager.winstate)
        {
            wintext.gameObject.SetActive(true);
        }
        if (Input.GetMouseButtonDown(0))
        {
            RaycastHit hit1;
            RaycastHit hit2;
            var ray = Camera.main.ScreenPointToRay(Input.mousePosition);
            
            if (Physics.Raycast(ray, out hit1))
            {
                ray = playercamera.ViewportPointToRay(hit1.textureCoord);
                if (Physics.Raycast(ray, out hit2))
                {
                    var obj = hit2.collider.gameObject;

                    if (obj.tag == "path")
                    {
                        int pathNum = int.Parse(obj.name.Substring(13));

                        if (pathNum != prevSelectPathNum)
                        {
                            pathName.text = obj.name;
                            var tmp = Camera.main.WorldToScreenPoint(hit1.point);
                            var mouseClickPosition = tmp - canvasSize * 0.5f + middlePoint;

                            var hitVector1 = mouseClickPosition - middlePoint;
                            hitVector1.z = 0;
                            var hitVector2 = new Vector3(hit2.point.x, hit2.point.z, 0.0f);
                            Debug.Log(hitVector1 + "test");
                            Debug.Log(hitVector2 + "test");
                            var k = hitVector1.magnitude / hitVector2.magnitude;
                            Debug.Log(k + "test");
                            var v = square.GetDestPoint(pathNum) - hitVector2;
                            v.z = 0;

                            _pathUI.transform.position = mouseClickPosition + k * v;
                            _pathUI.SetActive(true);
                            prevSelectPathNum = pathNum;
                        }
                        else
                        {
                            _pathUI.SetActive(false);
                            prevSelectPathNum = -1;
                        }
                    }
                    else
                    {
                        _pathUI.SetActive(false);
                        prevSelectPathNum = -1;
                    }
                }
            }
        }
        else if (Input.GetMouseButtonDown(1))
        {
            _pathUI.SetActive(false);
            prevSelectPathNum = -1;
        }
    }
}
