﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using MathNet.Numerics.LinearAlgebra;
using MathNet.Numerics.LinearAlgebra.Double;

public class Planemovement : MonoBehaviour
{
    bool toggle = false;
    bool grabbed = false;
    int cnt = 0;
    double beta = 0.5f; // v/c
    Vector3 alpha = new Vector3(0.1f, 0.0f, 0.0f); // proper acceleration
    Vector3 v;
    public LevelManager Levelmanager;
    public double starttime = 0.0f;
    public double gamma = 1.0f;
    Vector3 orientation;

    double time = 0.0f;
    // Start is called before the first frame update

    public GameObject theobject;

    public Planemovement otherclock;

    MatrixBuilder<double> M = Matrix<double>.Build;
    VectorBuilder<double> V = Vector<double>.Build;


    void Start()
    {
        //Renderer r = theobject.GetComponent<Renderer>();
        //Color materialColor = r.material.color;
        //r.material.color = Color.clear;
        v = new Vector3(0.0f, 0.0f, 0.0f);
        //playergamma = 1.0f;
        orientation = new Vector3(0.0f, 0.0f, 1.0f);
        time = starttime;
        gamma = 1.0f;
    }

    // Update is called once per frame

    // For physics calcs
    void FixedUpdate()
    {
        var prevup = transform.up;
        var prevfor = transform.forward;
        var prevorient = orientation;
        transform.Translate((float)Constants.c * Vector3.up * Time.fixedDeltaTime * (float)Levelmanager.player.gamma, Space.World); // move up by 1 second
        
        cnt++;
        if (cnt % 480 == 0)
        {
            cnt = 0;
        }
        if (alpha.magnitude > 0.0f)
        {

            var atmp = alpha.magnitude * Time.fixedDeltaTime;


            double[] vtmp = { (atmp * (alpha.x / alpha.magnitude)), 0.0, (atmp * (alpha.z / alpha.magnitude)) };
            var deltavnaive = V.DenseOfArray(vtmp);

            double[] tmp = {Constants.c * Constants.Gamma(deltavnaive.L2Norm()),
                      deltavnaive[0] * Constants.Gamma(deltavnaive.L2Norm()),
                      deltavnaive[2] * Constants.Gamma(deltavnaive.L2Norm())};

            var deltav = V.DenseOfArray(tmp);


            if (v.magnitude > 0.0f)
            {
                deltav = Constants.BoostMatrix(-v) * deltav;
            }

            var tt = deltav[0] / Constants.c;

            Vector3 finaldeltav = new Vector3((float)(deltav[1] / tt), 0.0f, (float)(deltav[2] / tt));

            var hmm = finaldeltav - v;

            v = finaldeltav;
        }

        if ((Levelmanager.player.transform.position - transform.position).magnitude < 1f)
        {
            toggle = true;
        }
        else
        {
            toggle = false;
        }

        if(toggle && Input.GetKeyDown("g"))
        {
            grabbed = !grabbed;
        }

        if(grabbed)
        {
            v = Levelmanager.player.v;
            Debug.Log("being grabbed");
        }
        else
        {
            v = new Vector3(0, 0, 0);
        }

        beta = v.magnitude / (float)Constants.c;

        gamma = Constants.Gamma(v.magnitude);

        transform.Translate(v * Time.fixedDeltaTime * (float)Levelmanager.player.gamma, Space.World);

        var vt = v + (float)Constants.c * Vector3.up;

        vt.x = -vt.x;

        vt.z = -vt.z;

        vt.Normalize();


        transform.localScale = new Vector3(1.0f, 1.0f, 1.0f); // release child to change x'-axis scale
        theobject.transform.up = vt;

        theobject.transform.parent = null;
        theobject.transform.RotateAround(theobject.transform.position, vt, Vector3.Angle(prevorient,orientation));

        Vector3 newforward = new Vector3(vt.y * (v.x/v.magnitude),Mathf.Sqrt(vt.x * vt.x + vt.z *vt.z), vt.y * (v.z / v.magnitude));

        transform.rotation = Quaternion.LookRotation(newforward, vt);
        
        theobject.transform.parent = transform;

        transform.localScale = new Vector3(1.0f, 1.0f, (float)gamma); // scale x' axis

        time += Time.fixedDeltaTime * (float)(Levelmanager.player.gamma / gamma);
    }

    public void OnCollisionStaychild(Collision collision)
    {
        //Debug.Log("hit!");
        //if(collision.transform.parent.name != "AnObject(Clone)")
        //    Debug.Log(collision.gameObject.name + " wow!");
        if (collision.transform.parent != null)
        {
            var x = collision.transform.parent.gameObject.GetComponent(typeof(Planemovement)) as Planemovement;
            if (x != null && x.Equals(otherclock))
            {
                Debug.Log("hit!");
                if (Mathf.Abs((float)(otherclock.GetTime() - time)) <= 1.0f)
                {
                    Levelmanager.winstate = true;
                }
            }
        }
       
    }

    public double GetTime()
    {
        return time;
    }
}
