﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LevelManager : MonoBehaviour
{

    public UIManager uiManager;

    public double gamma;
    public PlayerMovement player;

    public string[] ExplanationText = { "aa","bb"};

    [SerializeField]
    protected bool winstate = false;

    [SerializeField]
    protected bool DoubleClickMove = true;
    [SerializeField]
    protected bool PathRenderMove = true;
    [SerializeField]
    protected bool WASDMove = true;

    [SerializeField]
    protected string Todo;



    // Start is called before the first frame update
    protected virtual void Start()
    {
        winstate = false;


        uiManager.WASDMove = WASDMove;
        uiManager.PathCreateAble = PathRenderMove;
        uiManager.DoubleCLickMove = DoubleClickMove;

        uiManager.TodoText = Todo;

        uiManager.alert.Alert(ExplanationText);
    }

    // Update is called once per frame
    protected virtual void Update()
    {
        if (WinCondition())
        {
            WinState = true;
        }

        if (LoseCondition())
        {
            WinState = false;
        }
    }

    protected virtual void OnWin()
    {
        uiManager.WinTextOn();
    }

    protected virtual void OnLose()
    {

    }

    protected virtual bool LoseCondition()
    {
        return false;
    }

    protected virtual bool WinCondition()
    {
        return false;
    }
    public virtual bool WinState
    {
        set
        {
            if (value)
            {
                //if win
                OnWin();
            }
            else
            {
                //if lose
                OnLose();
            }
        }
    }

    public float XZLengthSquare(Vector3 a, Vector3 b)
    {
        return (a.x - b.x) * (a.x - b.x) + (a.z - b.z) * (a.z - b.z);
    }
}
