﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TutorialLevel2Manager : LevelManager
{
    // Start is called before the first frame update
    Vector3 orig;
    public GameObject target1;
    public GameObject target2;
    
    public Clock clock;
    bool isCond1;
    bool isCond2;
    bool isCond3;

    protected override void Start()
    {
        ExplanationText = new string[]{"어서오게 영웅이여!",
            "이동의 비법을 터득했으니, 이제 시공간 폭풍의 물체들을 직접 만져볼 때가 왔네.",
            "일단 저번 처럼 왼쪽에 있는 목표로 이동을 하세."
        };

        Todo = "목표 지점까지 이동하세요.";

        base.Start();


        isCond1 = false;
        isCond2 = false;
        isCond3 = false;


    }

    protected override void Update()
    {
        if (XZLengthSquare(player.transform.position, target1.transform.position) < 0.1 && !isCond1)
            Condition1();
        if (XZLengthSquare(clock.transform.position, target2.transform.position) < 0.1 && !isCond2)
            Condition2();
        if (Mathf.Abs((float)(clock.GetApparentTime() - player.time)) > 10.0 && clock.IsGrabbed && !isCond3 && isCond2)
            Condition3();
        base.Update();


    }

    protected override bool WinCondition()
    {
        if (isCond1 && isCond2 && isCond3)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    protected bool Condition1()
    {
        if (XZLengthSquare(player.transform.position, target1.transform.position) < 0.1 && !isCond1)
        {
            isCond1 = true;

            ExplanationText = new string[]{"자, 이제 왼쪽에 빨간색의 정사각형의 물체가 보일 것일세.",
            "그것은 시계라네. 가까이 다가가서 G를 누르면 잡을수 있고, 시계의 현재 시간을 읽을 수 있지.",
            "또한 부딫히면 상대론적 운동량을 보존하면서 튕겨나가는 것을 볼수 있네.",
            "참고로 시공간 폭풍의 세계에선 모든 충돌은 완전 탄성 충돌이라네.",
            "완전 탄성 충돌이란 건 즉 충돌 전과 후 정지 질량이 변하지 않는다는 말일세!",
            "그게 무슨 말이냐고? 으음...나중에 보여주겠네.",
            "기획자가 일을 다 하면 말이지.",
            "자, 그럼 어서 저 시계를 잡아 목표 지점까지 옮겨보게나.",
            "잡고 옮기던, 몸을 부딫혀 던지던 상관 없네." };
            uiManager.alert.Alert(ExplanationText);

            Todo = "빨간식 시계를 목표 지점까지 옮기세요.";
            uiManager.TodoText = Todo;
            target1.gameObject.SetActive(false);
            return true;
        }
        else
        {
            return false;
        }
    }

    protected bool Condition2()
    {
        if (XZLengthSquare(clock.transform.position, target2.transform.position) < 0.1 && !isCond2)
        {
            
            isCond2 = true;


            uiManager.WASDMove = WASDMove;
            uiManager.PathCreateAble = PathRenderMove;
            uiManager.DoubleCLickMove = DoubleClickMove;

            ExplanationText = new string[]{"그래 바로 그거야!",
            "좌측 상단에 My Proper Time 이라는 장소에 숫자가 있을 것이라네.",
            "그건 해당 레벨이 시작한지 자네의 입장에서 몇 초가 지났는지를 재는 시계라네.",
            "그런데 저 시계를 보게나. 자네의 시간과 미묘하게 다르지 않나?",
            "그렇다네. 자네가 보기에 빠르게 이동하는 것들은 시간이 느리게 흘러간다네.",
            "참고로 이건 반대로도 작용해. 모든 물체들은 항상 자기 자신이 정지해있다 생각해!",
            "이는 즉, 저 시계 입장에선 자네의 시간이 느리게 흐르게 된다는 것이지.",
            "모순 같다고? 전혀 아니라네. 시간과 공간을 따로 생각하지 말고, 함께 3차원 시공간으로 생각하면 전혀 모순이 아니지!",
            "한번 저 시계와 자네 시간이 10초 이상 차이나게 바꿔본다음 시계를 잡아보게나."
        };

            uiManager.alert.Alert(ExplanationText);

            Todo = "빨간 시계와 시간이 10초 이상 차이난 상태에서 잡기.";
            uiManager.TodoText = Todo;
            target2.gameObject.SetActive(false);
            return true;
        }
        else
        {
            return false;
        }
    }

    protected bool Condition3()
    {
        if (Mathf.Abs((float)(clock.GetApparentTime() - player.time)) > 10.0 && clock.IsGrabbed && !isCond3 && isCond2)
        {
            isCond3 = true;

            ExplanationText = new string[]{"대단해! 역시 자네는 선택받았군.",
            "이것이 바로 시간 지연일세.",
            "자네가 방금 보았다 시피, 자네가 보기엔 시계의 시간이 느리게 흐르고, 시계가 보기엔 자네의 시간이 느리게 흐르지만, (계속)",
            "시계와 다시 속도를 맞추니 시계가 더 빨리 흐른걸 볼수 있을 것이네.",
            "이 이유는 자네가 중간에 가속을 했기 때문이지.",
            "가속을 하는 동안은 관성계가 바뀌기 때문에 여러 재미있는 일들이 일어난다네.",
            "아, 안타깝게도 새로운 영웅이 나를 부르는군. 여기서부턴 자네가 알아서 헤쳐나가야 한다네.",
            "그럼, 이만! 시공간 폭풍에서 또 보게 된다면 그땐 같이 물리학 문제나 하나 풀세!"
        };


            uiManager.WASDMove = WASDMove;
            uiManager.PathCreateAble = PathRenderMove;
            uiManager.DoubleCLickMove = DoubleClickMove;

            uiManager.alert.Alert(ExplanationText);


            player.alpha = new Vector3(0, 0, 0);
            player.v = new Vector3(0, 0, 0);

            
            Todo = "";
            uiManager.TodoText = Todo;
            return true;
        }
        else
        {
            return false;
        }
    }

    

}
